/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.util;

import com.bdc.bdd.api.entity.core_classes.BddFlyingDragon;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;

public class DragonMoveControl
extends MoveControl {
    private final BddFlyingDragon dragon;

    public DragonMoveControl(BddFlyingDragon dragon) {
        super((Mob)dragon);
        this.dragon = dragon;
    }

    public void tick() {
        if (!this.dragon.isFlying()) {
            super.tick();
            return;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            double zDif;
            double yDif;
            this.operation = MoveControl.Operation.WAIT;
            double xDif = this.wantedX - this.mob.getX();
            double sq = xDif * xDif + (yDif = this.wantedY - this.mob.getY()) * yDif + (zDif = this.wantedZ - this.mob.getZ()) * zDif;
            if (sq < 2.500000277905201E-7) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            float speed = this.dragon.getFlyingSpeed();
            double distSq = Math.sqrt(xDif * xDif + zDif * zDif);
            this.mob.setSpeed(speed);
            if (Math.abs(yDif) > (double)1.0E-5f || Math.abs(distSq) > (double)1.0E-5f) {
                this.mob.setYya((float)yDif * speed);
            }
            float yaw = (float)(Mth.atan2((double)zDif, (double)xDif) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), yaw, 6.0f));
        } else {
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

