/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class DragonNodeEvaluator
extends FlyNodeEvaluator {
    private final Mob mob;
    public boolean allowFlying = false;
    public boolean allowSwimming = false;
    private final SwimNodeEvaluator swimNodeEvaluator;
    private final WalkNodeEvaluator walkNodeEvaluator;

    public DragonNodeEvaluator(Mob mob) {
        this.mob = mob;
        this.swimNodeEvaluator = new SwimNodeEvaluator(true);
        this.walkNodeEvaluator = new WalkNodeEvaluator();
    }

    public void prepare(PathNavigationRegion level, Mob mob) {
        super.prepare(level, mob);
        this.swimNodeEvaluator.prepare(level, mob);
        this.walkNodeEvaluator.prepare(level, mob);
    }

    public Node getStart() {
        if (this.allowSwimming) {
            return !this.mob.isInWater() ? super.getStart() : this.swimNodeEvaluator.getStart();
        }
        return super.getStart();
    }

    public Target getTarget(double x, double y, double z) {
        if (this.allowFlying) {
            return super.getTarget(x, y, z);
        }
        if (this.allowSwimming) {
            return this.swimNodeEvaluator.getTarget(x, y, z);
        }
        return this.walkNodeEvaluator.getTarget(x, y, z);
    }

    public boolean canStartAt(BlockPos pos) {
        if (this.allowFlying) {
            return super.canStartAt(pos);
        }
        if (this.allowSwimming) {
            return true;
        }
        PathType pathtype = this.getCachedPathType(pos.getX(), pos.getY(), pos.getZ());
        return pathtype != PathType.OPEN && this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    protected boolean isAmphibious() {
        return this.allowSwimming;
    }

    public int getNeighbors(Node[] outputArray, Node p_node) {
        if (this.allowFlying) {
            return super.getNeighbors(outputArray, p_node);
        }
        if (this.allowSwimming) {
            return this.swimNodeEvaluator.getNeighbors(outputArray, p_node);
        }
        return this.walkNodeEvaluator.getNeighbors(outputArray, p_node);
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z) {
        if (this.allowSwimming) {
            return this.swimNodeEvaluator.findAcceptedNode(x, y, z);
        }
        return super.findAcceptedNode(x, y, z);
    }

    @Nullable
    public Node findAcceptedNode(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType) {
        return this.walkNodeEvaluator.findAcceptedNode(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
    }

    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        if (this.allowSwimming) {
            return this.swimNodeEvaluator.getPathType(context, x, y, z);
        }
        if (this.allowFlying) {
            return super.getPathType(context, x, y, z);
        }
        return this.walkNodeEvaluator.getPathType(context, x, y, z);
    }
}

