/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.model;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.entity.core_classes.BddFlyingDragon;
import com.bdc.bdd.api.entity.core_classes.BddSaddleDragon;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderer;

public class BddDragonModel<T extends BddDragon>
extends BlueModel<T> {
    public float adultSize;
    public float babySize;

    public BddDragonModel(float adultScale, float babyScale) {
        this.adultSize = adultScale;
        this.babySize = babyScale;
    }

    @NotNull
    public ResourceLocation getModelResource(T pEntity, BlueRenderer<T> blueRenderer) {
        if (((BddBaseDragon)pEntity).getDragonStage() <= 2 && this.hasBabyModel()) {
            return BddCommon.Resource.model(true, this.getBabyModelFile(pEntity));
        }
        return BddCommon.Resource.model(false, this.getModelFile(pEntity));
    }

    @NotNull
    public ResourceLocation getTextureResource(T pEntity, @Nullable BlueRenderer<T> blueRenderer) {
        return ((BddBaseDragon)pEntity).getDragonLocation();
    }

    @NotNull
    public ResourceLocation getAnimationResource(T pEntity) {
        if (((BddBaseDragon)pEntity).getDragonStage() <= 2 && this.hasBabyModel()) {
            return BddCommon.Resource.animation(true, this.getBabyAnimationFile(pEntity));
        }
        return BddCommon.Resource.animation(false, this.getAnimationFile(pEntity));
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        super.setCustomAnimations(animatable, instanceId, animationState);
        BoneCache body = this.getAnimationProcessor().getBone(((BddBaseDragon)animatable).returnDragonType().getPath());
        BoneCache lefttailfin = this.getAnimationProcessor().getBone("lefttailfin");
        BoneCache Tail_Decor = this.getAnimationProcessor().getBone("Tail_Decor");
        if (body == null && lefttailfin == null && Tail_Decor == null) {
            return;
        }
        float targetPitch = 0.0f;
        float currentRoll = ((BddBaseDragon)animatable).getBodyRoll();
        if (((BddFlyingDragon)animatable).isFlying() && !((BddFlyingDragon)animatable).isHovering() && !animatable.onGround()) {
            if (((BddFlyingDragon)animatable).isGoingUp()) {
                targetPitch = 45.0f;
            } else if (((BddFlyingDragon)animatable).isDiving()) {
                targetPitch = -45.0f;
            }
            if (((BddSaddleDragon)animatable).getControllingPassenger() != null) {
                float bodyYaw;
                float playerHeadYaw = ((BddSaddleDragon)animatable).getControllingPassenger().getYHeadRot();
                float yawDiff = Mth.degreesDifference((float)playerHeadYaw, (float)(bodyYaw = Mth.lerp((float)animationState.getPartialTick(), (float)((BddDragon)animatable).yBodyRotO, (float)((BddDragon)animatable).yBodyRot)));
                if (Math.abs(yawDiff) > 5.0f) {
                    float rollIncrement = yawDiff * 0.008f;
                    currentRoll = Mth.clamp((float)(currentRoll + rollIncrement), (float)-90.0f, (float)90.0f);
                    ((BddBaseDragon)animatable).setBodyRoll(currentRoll);
                } else {
                    currentRoll = Mth.lerp((float)0.005f, (float)currentRoll, (float)0.0f);
                    ((BddBaseDragon)animatable).setBodyRoll(currentRoll);
                }
            }
        } else {
            currentRoll = Mth.lerp((float)0.005f, (float)currentRoll, (float)0.0f);
            ((BddBaseDragon)animatable).setBodyRoll(currentRoll);
        }
        float newPitch = Mth.lerp((float)0.005f, (float)((BddFlyingDragon)animatable).getBodyPitch(), (float)targetPitch);
        ((BddFlyingDragon)animatable).setBodyPitch(newPitch);
        body.setRotX(BddDragonModel.toRadians(newPitch));
        body.setRotZ(BddDragonModel.toRadians(currentRoll));
        if (lefttailfin != null && Tail_Decor != null) {
            lefttailfin.setHidden(!((BddBaseDragon)animatable).hasTailFin());
            Tail_Decor.setHidden(!((BddBaseDragon)animatable).hasFakeTailFin());
        }
    }

    public String getBabyModelFile(T pEntity) {
        return "baby_" + ((BddBaseDragon)pEntity).returnDragonType().getPath();
    }

    public String getBabyAnimationFile(T pEntity) {
        return "baby_" + ((BddBaseDragon)pEntity).returnDragonType().getPath();
    }

    public boolean hasBabyModel() {
        return false;
    }

    public String getModelFile(T pEntity) {
        return ((BddBaseDragon)pEntity).returnDragonType().getPath();
    }

    public String getAnimationFile(T pEntity) {
        return ((BddBaseDragon)pEntity).returnDragonType().getPath();
    }

    public static float toRadians(float pAngDeg) {
        return pAngDeg * ((float)Math.PI / 180);
    }
}

