/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.render.layer;

import com.bdc.bdd.api.entity.BddDragon;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class DragonGlowLayer<T extends BddDragon>
extends BlueRenderLayer<T> {
    private static final Function<ResourceLocation, RenderType> RENDER_TYPE_FUNCTION = texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"dragon_glow_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_EYES_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderType.COLOR_WRITE).createCompositeState(false));
    };

    public DragonGlowLayer(BlueRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(IRenderContext<T> pContext) {
        BddDragon animatable = (BddDragon)pContext.animatable();
        String glowingParam = Objects.requireNonNullElse(BddDragon.getParameterDataForVariant(animatable.returnDragonType(), animatable.getVariantName(), "glowing"), "false").toString().trim();
        if (!Boolean.parseBoolean(glowingParam)) {
            return;
        }
        ResourceLocation baseTexture = animatable.getDragonLocation();
        String basePath = baseTexture.getPath();
        String glowPath = basePath.substring(0, basePath.lastIndexOf(46)) + "_glow.png";
        ResourceLocation glowTexture = ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)glowPath);
        try {
            Minecraft.getInstance().getResourceManager().getResourceOrThrow(glowTexture);
        }
        catch (Exception e) {
            return;
        }
        RenderType glowRenderType = RENDER_TYPE_FUNCTION.apply(glowTexture);
        int packedLight = 0xF00000;
        int color = FastColor.ARGB32.opaque((int)0xFFFFFF);
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            full.setRenderType(glowRenderType);
            full.setBuffer(full.bufferSource().getBuffer(glowRenderType));
            full.setPackedLight(0xF00000);
            full.setPackedOverlay(OverlayTexture.NO_OVERLAY);
            full.setColor(color);
            this.getRenderer().reRender((IRenderContext)full);
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            base.setPackedLight(0xF00000);
            base.setPackedOverlay(OverlayTexture.NO_OVERLAY);
            base.setColor(color);
            this.getRenderer().reRender((IRenderContext)base);
        }
    }
}

