/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.util;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.util.BDDKeyMappings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum DragonAbilities implements StringRepresentable
{
    HOVER("Hover", BDDKeyMappings.HOVER, "hover_ability_icon"),
    FLIGHT_LOCK("Flight Lock", BDDKeyMappings.FLIGHT_LOCK, "flight_lock_ability_icon"),
    ROAR("Roar", BDDKeyMappings.ROAR, "roar_ability_icon"),
    BITE("Bite", BDDKeyMappings.BITE, "bite_ability_icon"),
    FIRE_BREATH("Fire Breath", BDDKeyMappings.BLAST, "flame_shot_ability_icon"),
    PLASMA_BLAST("Plasma Shot", BDDKeyMappings.BLAST, "plasma_blast_ability_icon"),
    FIRE_BLAST("Fire Ball", BDDKeyMappings.BLAST, "fire_ball_ability_icon"),
    TAIL_WHIP("Tail Whip", BDDKeyMappings.TAIL_WHIP, "tail_whip_ability_icon"),
    SPINE_SHOT("Spine Shot", BDDKeyMappings.SECONDARY_ABILITY, "spine_shot_ability_icon"),
    GAS_BOMB("Gas Bomb", BDDKeyMappings.BLAST, "gas_explosion_ability_icon"),
    GAS_SPARK("Gas Spark", BDDKeyMappings.SECONDARY_ABILITY, "gas_explosion_ability_icon"),
    FLAME_BODY("Flame Body", BDDKeyMappings.SECONDARY_ABILITY, "flame_body_ability_icon"),
    SPEED_UP("Speed Up", BDDKeyMappings.SPEED_UP, "speed_up_ability_icon"),
    SPEED_DOWN("Speed Down", BDDKeyMappings.SPEED_DOWN, "speed_down_ability_icon");

    private final String displayName;
    private final BDDKeyMappings keyMapping;
    private final String spritePath;

    private DragonAbilities(String pDisplayName, BDDKeyMappings pKeyMapping, String pSpritePath) {
        this.displayName = pDisplayName;
        this.keyMapping = pKeyMapping;
        this.spritePath = pSpritePath;
    }

    @NotNull
    public String getSerializedName() {
        return this.displayName;
    }

    public String getKeybind() {
        if (this.keyMapping == null) {
            return "?";
        }
        return BddConstants.PlatformHelper.MISC.getKey(this.keyMapping).getTranslatedKeyMessage().getString();
    }

    public ResourceLocation getSprite() {
        return BddCommon.Resource.guiIcon(this.spritePath);
    }
}

