/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.mixin;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.util.DragonAbilities;
import com.bdc.bdd.inventory.BddGuiOverlays;
import com.bdc.bdd.util.BddGuiUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class DragonInfoMixin {
    @Inject(method={"renderVehicleHealth"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelMountHealthBar(GuiGraphics guiGraphics, CallbackInfo ci) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        int xPos = 110;
        int negXPos = -110;
        if (mc.player != null && (entity = mc.player.getVehicle()) instanceof BddAbilityDragon) {
            BddAbilityDragon dragon = (BddAbilityDragon)entity;
            BddGuiUtils.renderBar(guiGraphics, BddCommon.Resource.guiTexture("dragon_health"), BddCommon.Resource.guiTexture("dragon_health_back"), 43, 34, dragon.getHealth(), dragon.getMaxHealth(), 60, 62);
            BddGuiUtils.renderBar(guiGraphics, BddCommon.Resource.guiTexture("dragon_speed"), BddCommon.Resource.guiTexture("dragon_speed_back"), 43, 34, dragon.getFlyingSpeed(), BddBaseDragon.MAX_FLYING_SPEED, 60, 82);
            BddGuiUtils.renderBar(guiGraphics, BddCommon.Resource.guiTexture("dragon_stamina"), BddCommon.Resource.guiTexture("dragon_stamina_back"), 43, 34, dragon.getDragonStamina(), 100.0f, 60, 102);
            xPos = BddGuiUtils.renderAbilityIfHas(guiGraphics, dragon, DragonAbilities.BITE, xPos, 27, true);
            xPos = BddGuiUtils.renderAbilityIfHas(guiGraphics, dragon, DragonAbilities.ROAR, xPos, 27, true);
            xPos = BddGuiUtils.renderBreathBarIfHas(guiGraphics, BddCommon.Resource.guiIcon("gas_explosion_ability_icon"), BddCommon.Resource.guiIcon("back/gas_explosion_ability_icon_back"), dragon, DragonAbilities.GAS_BOMB, dragon.getRemainingFuel(), 2800.0f, xPos, 27, true);
            xPos = BddGuiUtils.renderProjBarIfHas(guiGraphics, BddCommon.Resource.guiIcon("fire_ball_ability_icon"), BddCommon.Resource.guiIcon("back/fire_ball_ability_icon_back"), dragon, DragonAbilities.FIRE_BLAST, " ( " + dragon.getProjectileShots() + " )", dragon.getPlayerBoltBlastPendingScale(), dragon.getMaxPlayerBoltBlast(), xPos, 27, true);
            negXPos = BddGuiUtils.renderAbilityIfHas(guiGraphics, dragon, DragonAbilities.TAIL_WHIP, negXPos, 27, false);
            negXPos = BddGuiUtils.renderBreathBarIfHas(guiGraphics, BddCommon.Resource.guiIcon("flame_shot_ability_icon"), BddCommon.Resource.guiIcon("back/flame_shot_ability_icon_back"), dragon, DragonAbilities.FIRE_BREATH, dragon.getRemainingFuel(), 2800.0f, negXPos, 27, false);
            negXPos = BddGuiUtils.renderAbilityIfHas(guiGraphics, dragon, DragonAbilities.SPINE_SHOT, negXPos, 27, false);
            negXPos = BddGuiUtils.renderAbilityIfHas(guiGraphics, dragon, DragonAbilities.FLAME_BODY, negXPos, 27, false);
            BddGuiUtils.renderProjBarIfHas(guiGraphics, BddCommon.Resource.guiIcon("plasma_blast_ability_icon"), BddCommon.Resource.guiIcon("back/plasma_blast_ability_icon_back"), dragon, DragonAbilities.PLASMA_BLAST, " ( " + dragon.getProjectileShots() + " )", dragon.getPlayerBoltBlastPendingScale(), dragon.getMaxPlayerBoltBlast(), negXPos, 27, false);
            ci.cancel();
        }
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")})
    private void renderStatBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.crosshairPickEntity;
        if (entity instanceof BddBaseDragon) {
            BddBaseDragon dragon = (BddBaseDragon)entity;
            if (!BddConstants.PlatformHelper.MISC.getConfig()) {
                BddGuiOverlays.renderStatBox(guiGraphics, mc, dragon);
            }
        }
    }
}

