/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BaseLinearBoltProjectile
extends BaseLinearFlightProjectile {
    public BddAbilityDragon dragon;

    public BaseLinearBoltProjectile(EntityType type, Level level) {
        super(type, level);
    }

    public BaseLinearBoltProjectile(EntityType type, BddAbilityDragon owner, Vec3 start, Vec3 lookDirection, Level level, int strengthRadius) {
        super(type, level);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.setOwner((Entity)owner);
        this.start = start;
        this.end = lookDirection;
        this.moveTo(this.start.x(), this.start.y(), this.start.z(), this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.setNoGravity(true);
    }

    @Override
    public void shoot(Vec3 lookDirection, float partialTicks) {
        this.shoot(lookDirection, partialTicks, 5.0);
    }

    @Override
    public void shoot(Vec3 lookDirection, float partialTicks, double velocity) {
        if (partialTicks == 1.0f) {
            if (this.dragon.tier1()) {
                this.setDamageTier(1);
            } else if (this.dragon.tier2()) {
                this.setDamageTier(2);
            } else if (this.dragon.tier3()) {
                this.setDamageTier(3);
            } else if (this.dragon.tier4()) {
                this.setDamageTier(4);
            }
            this.setDeltaMovement(lookDirection.x * velocity, lookDirection.y * velocity, lookDirection.z * velocity);
            double horizontalDistance = lookDirection.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)lookDirection.x, (double)lookDirection.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)lookDirection.y, (double)horizontalDistance) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    @Override
    public void shoot(Vec3 lookDirection, float partialTicks, float pInaccuracy, double pVelocity) {
        if (partialTicks == 1.0f) {
            this.setDeltaMovement(lookDirection.x * pVelocity, lookDirection.y * pVelocity, lookDirection.z * pVelocity);
            double horizontalDistance = lookDirection.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)lookDirection.x, (double)lookDirection.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)lookDirection.y, (double)horizontalDistance) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    @Override
    public void tick() {
        this.baseTick();
        this.ticksExisted += 1.0;
        if (this.isNoGravity()) {
            this.setNoGravity(true);
        }
        Vec3 currentPos = this.position();
        Vec3 deltaMovement = this.getDeltaMovement();
        Vec3 nextPos = currentPos.add(deltaMovement);
        BlockHitResult blockHitResult = this.level.clip(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.getBoundingBox().expandTowards(deltaMovement).inflate(6.0).expandTowards(1.0, 3.0, 1.0), x$0 -> this.canHitEntity((Entity)x$0));
        BlockHitResult finalHitResult = blockHitResult;
        if (entityHitResult != null) {
            double blockHitDistanceSqr;
            double entityHitDistanceSqr = entityHitResult.getLocation().distanceToSqr(currentPos);
            double d = blockHitDistanceSqr = blockHitResult.getType() != HitResult.Type.MISS ? blockHitResult.getLocation().distanceToSqr(currentPos) : Double.MAX_VALUE;
            if (entityHitDistanceSqr < blockHitDistanceSqr) {
                finalHitResult = entityHitResult;
            }
        }
        if (finalHitResult.getType() != HitResult.Type.MISS) {
            nextPos = finalHitResult.getLocation();
            this.onHit((HitResult)finalHitResult);
        }
        this.setPos(nextPos.x, nextPos.y, nextPos.z);
        this.playParticles();
        if (this.ticksExisted > (double)this.threshHoldForDeletion()) {
            this.discard();
            this.ticksExisted = 0.0;
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level.isClientSide && this.dragon != null) {
            boolean mobGriefing = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            this.explode(this.dragon, this.getX(), this.getY(), this.getZ(), this.dragon.getExplosionStrength(), mobGriefing, mobGriefing ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
            this.callExplosionEffects(mobGriefing, this.dragon);
            this.discard();
            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity;
        super.onHitEntity(entityHitResult);
        if (!this.level.isClientSide && this.dragon != null && (entity = entityHitResult.getEntity()) != this.dragon && entity != this.getOwner() && !(entity instanceof BaseLinearFlightProjectile)) {
            float damage = this.dragon.getProjectileDamage(this.dragon, entity, this);
            float finalDamage = !(entity instanceof Player) && !(entity instanceof BddAbilityDragon) ? damage : damage / 3.0f;
            boolean mobGriefing = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.getEffect(MobEffects.FIRE_RESISTANCE) == null) {
                    entity.hurt(this.damageSources().mobAttack((LivingEntity)this.dragon), finalDamage);
                    entity.setRemainingFireTicks(7);
                }
            } else {
                entity.hurt(this.damageSources().mobAttack((LivingEntity)this.dragon), finalDamage);
                entity.setRemainingFireTicks(7);
            }
            this.explode(this.dragon, this.getX(), this.getY(), this.getZ(), this.dragon.getExplosionStrength(), mobGriefing, mobGriefing ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
            this.callExplosionEffects(mobGriefing, this.dragon);
            this.discard();
            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
        }
    }

    @Override
    public Explosion explode(BddAbilityDragon pEntity, double pX, double pY, double pZ, float pExplosionRadius, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        return this.explode((Entity)pEntity, null, null, pX, pY, pZ, pExplosionRadius, pCausesFire, pMode);
    }

    private Explosion explode(@Nullable Entity exploder, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float size, boolean causesFire, Explosion.BlockInteraction mode) {
        FireBoltExplosion explosion = new FireBoltExplosion(this.level, exploder, x, y, z, size, this.getAffectedBlocks(x, y, z, size), mode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder<SoundEvent>)SoundEvents.GENERIC_EXPLODE);
        explosion.explode();
        explosion.finalizeExplosion(true);
        return explosion;
    }

    private List<BlockPos> getAffectedBlocks(double x, double y, double z, float size) {
        ArrayList<BlockPos> affectedBlocks = new ArrayList<BlockPos>();
        int ix = (int)Math.floor(x - (double)size);
        while ((double)ix <= Math.ceil(x + (double)size)) {
            int iy = (int)Math.floor(y - (double)size);
            while ((double)iy <= Math.ceil(y + (double)size)) {
                int iz = (int)Math.floor(z - (double)size);
                while ((double)iz <= Math.ceil(z + (double)size)) {
                    BlockPos pos = new BlockPos(ix, iy, iz);
                    double distance = pos.distSqr((Vec3i)new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)));
                    BlockState blockState = this.level.getBlockState(pos);
                    Block block = blockState.getBlock();
                    if (block != Blocks.OBSIDIAN && block != Blocks.BEDROCK && distance <= (double)(size * size)) {
                        affectedBlocks.add(pos);
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return affectedBlocks;
    }

    public static class FireBoltExplosion
    extends Explosion {
        public FireBoltExplosion(Level level, Entity source, double x, double y, double z, float radius, List<BlockPos> toBlow, Explosion.BlockInteraction blockInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder<SoundEvent> explosionSound) {
            super(level, source, x, y, z, radius, toBlow, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
        }

        public void explode() {
            int l;
            int k;
            this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new BlockPos((int)this.x, (int)this.y, (int)this.z));
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    block2: for (l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.x;
                        double d6 = this.y;
                        double d8 = this.z;
                        float f1 = 0.3f;
                        for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos((int)d4, (int)d6, (int)d8);
                            BlockState blockstate = this.level.getBlockState(blockpos);
                            FluidState fluidstate = this.level.getFluidState(blockpos);
                            if (!this.level.isInWorldBounds(blockpos)) continue block2;
                            if (blockstate.getBlock() == Blocks.OBSIDIAN || blockstate.getBlock() == Blocks.BEDROCK) continue;
                            Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * 0.3;
                            d6 += d1 * 0.3;
                            d8 += d2 * 0.3;
                        }
                    }
                }
            }
            this.toBlow.addAll((Collection)set);
            float f2 = this.radius * 2.0f;
            k = Mth.floor((double)(this.x - (double)f2 - 1.0));
            l = Mth.floor((double)(this.x + (double)f2 + 1.0));
            int i2 = Mth.floor((double)(this.y - (double)f2 - 1.0));
            int i1 = Mth.floor((double)(this.y + (double)f2 + 1.0));
            int j2 = Mth.floor((double)(this.z - (double)f2 - 1.0));
            int j1 = Mth.floor((double)(this.z + (double)f2 + 1.0));
            List list = this.level.getEntities(this.source, new AABB((double)k, (double)i2, (double)j2, (double)l, (double)i1, (double)j1));
            Vec3 vec3 = new Vec3(this.x, this.y, this.z);
            for (Entity entity : list) {
                Player player;
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                if (entity.ignoreExplosion((Explosion)this) || entity == this.getDirectSourceEntity() || entity.isInvulnerableTo(this.level.damageSources().inFire()) || entity.isInvulnerableTo(this.level.damageSources().onFire()) || !((d12 = Math.sqrt(entity.distanceToSqr(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.getX() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y) * d7 + (d9 = entity.getZ() - this.z) * d9)) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d14 = FireBoltExplosion.getSeenPercent((Vec3)vec3, (Entity)entity);
                double d10 = (1.0 - d12) * d14;
                if (entity != this.source) {
                    entity.hurt(FireBoltExplosion.getDefaultDamageSource((Level)this.level, (Entity)entity), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
                }
                double d11 = d10;
                if (entity instanceof LivingEntity) {
                    d11 = this.damageCalculator.getKnockbackMultiplier(entity);
                }
                entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
                if (!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying) continue;
                this.getHitPlayers().put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
            }
        }

        public void finalizeExplosion(boolean pSpawnParticles) {
            boolean flag;
            boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.KEEP;
            if (pSpawnParticles) {
                if (this.radius >= 2.0f && flag) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                } else {
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                }
            }
            if (flag) {
                ArrayList objectarraylist = new ArrayList();
                Random random1 = new Random();
                Collections.shuffle(this.toBlow, random1);
                for (BlockPos blockpos : this.getToBlow()) {
                    BlockState blockstate = this.level.getBlockState(blockpos);
                    if (blockstate.isAir()) continue;
                    BlockPos blockpos1 = blockpos.immutable();
                    if (this.level instanceof ServerLevel) {
                        BlockEntity blockentity = blockstate.hasBlockEntity() ? this.level.getBlockEntity(blockpos) : null;
                        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockpos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockentity).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.source);
                        if (this.getBlockInteraction() == Explosion.BlockInteraction.DESTROY) {
                            lootcontext$builder.withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)Float.valueOf(this.radius));
                        }
                        blockstate.getDrops(lootcontext$builder).forEach(itemStack -> FireBoltExplosion.addOrAppendStack((List)objectarraylist, (ItemStack)itemStack, (BlockPos)blockpos1));
                    }
                    this.level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 3);
                }
                int fireRadius = 1;
                for (int dx = -fireRadius; dx <= fireRadius; ++dx) {
                    for (int dy = -fireRadius; dy <= fireRadius; ++dy) {
                        for (int dz = -fireRadius; dz <= fireRadius; ++dz) {
                            BlockPos firePos = new BlockPos((int)(this.x + (double)dx), (int)(this.y + (double)dy), (int)(this.z + (double)dz));
                            BlockState fireState = this.level.getBlockState(firePos);
                            if (!fireState.isAir()) continue;
                            this.level.setBlock(firePos, Blocks.FIRE.defaultBlockState(), 3);
                        }
                    }
                }
                this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                for (Pair pair : objectarraylist) {
                    ItemStack itemstack = (ItemStack)pair.getFirst();
                    BlockPos blockpos2 = (BlockPos)pair.getSecond();
                    if (itemstack.isEmpty()) continue;
                    Block.dropResources((BlockState)this.level.getBlockState(blockpos2), (Level)this.level, (BlockPos)blockpos2, null, (Entity)this.source, (ItemStack)itemstack);
                }
            }
        }
    }
}

