/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile.zipple_gas;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import com.bdc.bdd.registry.EntityRegistry;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ZipplebackGas
extends BaseLinearFlightProjectile {
    public ZipplebackGas(EntityType<? extends ZipplebackGas> type, Level level) {
        super(type, level);
    }

    public ZipplebackGas(BddAbilityDragon dragonOwner, Vec3 throat, Vec3 end, Level level) {
        super(EntityRegistry.ZIPPLEBACK_GAS.get(), dragonOwner, throat, end, level, 1);
    }

    @Override
    public void playParticles() {
        float scale = (float)this.ticksExisted * 2.0f + 5.0f;
        double posX = this.xo + (this.random.nextDouble() - this.random.nextDouble()) * (this.ticksExisted / 2.0);
        double posY = this.yo + (this.random.nextDouble() - this.random.nextDouble()) * (this.ticksExisted / 2.0);
        double posZ = this.zo + (this.random.nextDouble() - this.random.nextDouble()) * (this.ticksExisted / 2.0);
        SimpleParticleType particleOptions = ParticleTypes.CAMPFIRE_COSY_SMOKE;
        this.level.addParticle((ParticleOptions)particleOptions, true, posX, posY, posZ, (double)scale * 5.8 + 0.1 * (double)(this.random.nextFloat() - 0.5f), (double)scale * 5.8 * 0.1 * (double)(this.random.nextFloat() - 0.5f), (double)scale * 5.8 + 0.1 * (double)(this.random.nextFloat() - 0.5f));
    }

    @Override
    public void tick() {
        super.tick();
        BddAbilityDragon owner = this.getOwner();
        if (this.level.isClientSide || owner == null || !owner.isRemoved()) {
            ClipContext.Block blockContext = ClipContext.Block.COLLIDER;
            HitResult hitresult = ProjectileUtil.getHitResult((Vec3)this.getPosition(1.0f), (Entity)this, this::canHitEntity, (Vec3)this.getDeltaMovement(), (Level)this.level, (float)1.0f, (ClipContext.Block)blockContext);
            if (hitresult.getType() != HitResult.Type.MISS) {
                this.end = hitresult.getLocation();
            }
            if (!this.level.isClientSide() && hitresult.getType() != HitResult.Type.MISS) {
                BlockHitResult blockHitResult;
                HitResult.Type hitresult$type = hitresult.getType();
                if (hitresult$type == HitResult.Type.ENTITY && hitresult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitresult;
                    Entity entity = entityHitResult.getEntity();
                    boolean mobGriefing = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                    if (entity != this.dragon) {
                        TamableAnimal tamableAnimal;
                        if (mobGriefing) {
                            entity.hurt(this.damageSources().explosion((Entity)this.dragon, (Entity)this), 14.0f);
                            this.discard();
                            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                        } else if (!mobGriefing && !entity.hasCustomName() && entity instanceof TamableAnimal && !(tamableAnimal = (TamableAnimal)entity).isTame()) {
                            entity.hurt(this.damageSources().explosion((Entity)this.dragon, (Entity)this), 8.0f);
                            if (entity.isOnFire()) {
                                this.explode(this.getOwner(), entity.getX(), entity.getY(), entity.getZ(), 4.0f, true, Explosion.BlockInteraction.KEEP);
                            }
                            this.discard();
                            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                        }
                    }
                    return;
                }
                if (hitresult$type == HitResult.Type.BLOCK && hitresult instanceof BlockHitResult && !(this.level.getBlockState((blockHitResult = (BlockHitResult)hitresult).getBlockPos()).getBlock() instanceof BushBlock)) {
                    boolean mobGriefing = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                    if (mobGriefing) {
                        this.makeAreaOfEffectCloud();
                    }
                    this.discard();
                    this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                }
            }
            this.checkInsideBlocks();
            Vec3 deltaMovement = this.getDeltaMovement();
            double x = this.getX() + deltaMovement.x;
            double y = this.getY() + deltaMovement.y;
            double z = this.getZ() + deltaMovement.z;
            float inertia = this.getInertia();
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x - deltaMovement.x * 0.25, y - deltaMovement.y * 0.25, z - deltaMovement.z * 0.25, deltaMovement.x, deltaMovement.y, deltaMovement.z);
                }
                inertia = 0.8f;
            }
            this.setDeltaMovement(deltaMovement.add(this.accelerationPower, this.accelerationPower, this.accelerationPower).scale((double)inertia));
            this.setPos(x, y, z);
        }
        this.playParticles();
        this.ticksExisted += 1.0;
        if (this.ticksExisted > 7.0) {
            this.discard();
            this.ticksExisted = 0.0;
        }
    }

    @Override
    protected Explosion explode(BddAbilityDragon var1, double var2, double var4, double var6, float var8, boolean var9, Explosion.BlockInteraction var10) {
        return null;
    }

    protected boolean canHitEntity(Entity hitEntity) {
        return super.canHitEntity(hitEntity) && hitEntity != this.dragon;
    }

    @NotNull
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.EFFECT;
    }

    private void makeAreaOfEffectCloud() {
        ZippleBackAOECloud areaeffectcloud = new ZippleBackAOECloud(this.level, this.getX(), this.getY(), this.getZ());
        BddAbilityDragon entity = this.getOwner();
        if (entity != null) {
            areaeffectcloud.setOwner((LivingEntity)entity);
        }
        areaeffectcloud.setRadius(2.0f);
        areaeffectcloud.setRadiusOnUse(-0.5f);
        areaeffectcloud.setWaitTime(10);
        areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
        areaeffectcloud.setPotionContents(new PotionContents(Potions.POISON));
        ZipplebackGas.spawnParticles(this);
        areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.POISON, BddUtil.secondsToTicks(25)));
        this.level.addFreshEntity((Entity)areaeffectcloud);
    }

    @Override
    public void shoot(Vec3 end, float partialTicks) {
        if (partialTicks == 1.0f) {
            Vec3 endVec = new Vec3(end.x() * 4.8, end.y() * 4.8, end.z() * 4.8);
            this.setDeltaMovement(endVec);
            double d0 = end.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)end.x, (double)end.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)end.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getYRot();
        }
    }

    public static class ZippleBackAOECloud
    extends AreaEffectCloud {
        private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(ZippleBackAOECloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

        public ZippleBackAOECloud(EntityType<? extends AreaEffectCloud> cloud, Level level) {
            super(cloud, level);
        }

        public ZippleBackAOECloud(Level level, double x, double y, double z) {
            this((EntityType<? extends AreaEffectCloud>)EntityType.AREA_EFFECT_CLOUD, level);
            this.setPos(x, y, z);
        }

        protected void defineSynchedData(SynchedEntityData.Builder builder) {
            super.defineSynchedData(builder);
            builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        }

        protected void readAdditionalSaveData(CompoundTag pCompound) {
            super.readAdditionalSaveData(pCompound);
            this.setDamage(pCompound.getFloat("damage"));
        }

        protected void addAdditionalSaveData(CompoundTag pCompound) {
            super.addAdditionalSaveData(pCompound);
            pCompound.putFloat("damage", this.getDamage());
        }

        public void tick() {
            super.tick();
            if (this.checkInFire() || this.getDamage() > 1.0f) {
                this.explode();
            }
        }

        private boolean checkInFire() {
            AABB aabb = this.getBoundingBox();
            int i = Mth.floor((double)aabb.minX);
            int j = Mth.ceil((double)aabb.maxX);
            int k = Mth.floor((double)aabb.minY);
            int l = Mth.ceil((double)aabb.maxY);
            int i1 = Mth.floor((double)aabb.minZ);
            int j1 = Mth.ceil((double)aabb.maxZ);
            boolean flag = false;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$mutableblockpos.set(k1, l1, i2);
                        BlockState state = this.level.getBlockState((BlockPos)blockpos$mutableblockpos);
                        if (!(this.level.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() instanceof BaseFireBlock) && this.level.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() != Blocks.LAVA && !(this.level.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() instanceof CandleBlock) && state.getLightEmission() <= 4) continue;
                        flag = true;
                    }
                }
            }
            return flag;
        }

        public void explode() {
            boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            if (flag) {
                this.level.explode(null, this.getX(), this.getY(), this.getZ(), this.getRadius() + 1.0f, Level.ExplosionInteraction.NONE);
            }
            this.discard();
        }

        public float getDamage() {
            return ((Float)this.entityData.get(DATA_ID_DAMAGE)).floatValue();
        }

        public void setDamage(float pDamageTaken) {
            this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamageTaken));
        }

        public boolean isInvulnerableTo(DamageSource pSource) {
            if (pSource.is(DamageTypes.ON_FIRE) || pSource.is(DamageTypes.IN_FIRE) || pSource.is(DamageTypes.LAVA) || pSource == this.damageSources().explosion(null)) {
                return false;
            }
            return super.isInvulnerableTo(pSource);
        }

        public boolean hurt(DamageSource pSource, float pAmount) {
            if (this.isInvulnerableTo(pSource)) {
                return false;
            }
            if (!this.level.isClientSide && !this.isRemoved()) {
                this.setDamage(this.getDamage() + pAmount * 10.0f);
                this.markHurt();
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, pSource.getEntity());
                return true;
            }
            return true;
        }

        public boolean fireImmune() {
            return false;
        }
    }
}

