/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.blocks;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.registry.helpers.blocks.BddBlockModelGenerator;
import com.bdc.bdd.registry.helpers.blocks.BddBlockModelTemplates;
import com.bdc.bdd.registry.helpers.blockstates.BddBlockstateGenerator;
import com.bdc.bdd.registry.helpers.blockstates.BddBlockstateTemplates;
import com.bdc.bdd.registry.helpers.items.BddItemModelGenerator;
import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BddBlockBuilder<T extends Block> {
    public static final List<BddBlockBuilder<?>> REGISTERED_BUILDERS = new ArrayList();
    public static String blockName;
    public final Function<BlockBehaviour.Properties, T> blockConstructor;
    public BlockBehaviour.Properties properties;
    public static boolean createDefaultItem;
    public T registeredBlock;
    public static BddBlockstateTemplates blockstateTemplate;
    public static BddBlockModelTemplates blockModelTemplate;
    private BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntityFactory;
    private Supplier<BlockEntityRendererProvider<?>> rendererProvider;
    private Supplier<? extends BlockEntityType<? extends BlockEntity>> blockEntityType;
    private static Supplier<BlockEntityType<? extends BlockEntity>> blockEntityTypeSupplier;

    public BddBlockBuilder(String name, Function<BlockBehaviour.Properties, T> blockConstructor) {
        blockName = name;
        this.blockConstructor = blockConstructor;
    }

    public BddBlockBuilder<T> properties(BlockBehaviour.Properties properties) {
        this.properties = properties;
        return this;
    }

    public BddBlockBuilder<T> defaultItem() {
        createDefaultItem = true;
        return this;
    }

    public BddBlockBuilder<T> defaultBlockstate() {
        return this.datagen().blockstate(BddBlockstateTemplates.SIMPLE_BLOCK).model(BddBlockModelTemplates.CUBE_ALL).finish();
    }

    public BddBlockBuilder<T> button(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.BUTTON_BLOCK, BddBlockModelTemplates.BUTTON, BddItemModelTemplates.BLOCK_WITH_INVENTORY_MODEL);
        return this;
    }

    public BddBlockBuilder<T> log(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.ORIENTED_BLOCK, BddBlockModelTemplates.COLUMN, BddItemModelTemplates.BLOCK_ITEM);
        return this;
    }

    public BddBlockBuilder<T> slab(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.SLAB_BLOCK, BddBlockModelTemplates.SLAB, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> door(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.DOOR_BLOCK, BddBlockModelTemplates.DOOR, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> fence(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.FENCE_BLOCK, BddBlockModelTemplates.FENCE, BddItemModelTemplates.BLOCK_WITH_INVENTORY_MODEL);
        BddItemModelGenerator.generateItemModel(modId, blockName, BddItemModelTemplates.GENERATED);
        return this;
    }

    public BddBlockBuilder<T> fenceGate(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.FENCE_GATE_BLOCK, BddBlockModelTemplates.FENCE_GATE, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> trapdoor(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.TRAPDOOR_BLOCK, BddBlockModelTemplates.TRAPDOOR, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> stairs(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.STAIRS_BLOCK, BddBlockModelTemplates.STAIRS, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> pressurePlate(String modId) {
        this.generate(modId, blockName, BddBlockstateTemplates.PRESSURE_PLATE_BLOCK, BddBlockModelTemplates.PRESSURE_PLATE, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    public BddBlockBuilder<T> tree(String modId) {
        this.generate(modId, blockName + "_log", BddBlockstateTemplates.ORIENTED_BLOCK, BddBlockModelTemplates.COLUMN, BddItemModelTemplates.BLOCK_ITEM);
        this.generate(modId, blockName + "_planks", BddBlockstateTemplates.SIMPLE_BLOCK, BddBlockModelTemplates.CUBE_ALL, BddItemModelTemplates.BLOCK_ITEM);
        this.generate(modId, blockName + "_leaves", BddBlockstateTemplates.SIMPLE_BLOCK, BddBlockModelTemplates.CUBE_ALL, BddItemModelTemplates.BLOCK_ITEM);
        return this;
    }

    public BddBlockBuilder<T> wood(String modId) {
        this.generate(modId, blockName + "_log", BddBlockstateTemplates.ORIENTED_BLOCK, BddBlockModelTemplates.COLUMN, BddItemModelTemplates.BLOCK_ITEM);
        this.generate(modId, blockName + "_planks", BddBlockstateTemplates.SIMPLE_BLOCK, BddBlockModelTemplates.CUBE_ALL, BddItemModelTemplates.BLOCK_ITEM);
        this.generate(modId, blockName + "_fence", BddBlockstateTemplates.FENCE_BLOCK, BddBlockModelTemplates.FENCE, BddItemModelTemplates.BLOCK_WITH_INVENTORY_MODEL);
        BddItemModelGenerator.generateItemModel(modId, blockName + "_fence", BddItemModelTemplates.GENERATED);
        this.generate(modId, blockName + "_door", BddBlockstateTemplates.DOOR_BLOCK, BddBlockModelTemplates.DOOR, BddItemModelTemplates.BLOCK_SPRITE);
        this.generate(modId, blockName + "_button", BddBlockstateTemplates.BUTTON_BLOCK, BddBlockModelTemplates.BUTTON, BddItemModelTemplates.BLOCK_WITH_INVENTORY_MODEL);
        this.generate(modId, blockName + "_slab", BddBlockstateTemplates.SLAB_BLOCK, BddBlockModelTemplates.SLAB, BddItemModelTemplates.BLOCK_SPRITE);
        this.generate(modId, blockName + "_pressure_plate", BddBlockstateTemplates.PRESSURE_PLATE_BLOCK, BddBlockModelTemplates.PRESSURE_PLATE, BddItemModelTemplates.BLOCK_SPRITE);
        this.generate(modId, blockName + "_stairs", BddBlockstateTemplates.STAIRS_BLOCK, BddBlockModelTemplates.STAIRS, BddItemModelTemplates.BLOCK_SPRITE);
        this.generate(modId, blockName + "_trapdoor", BddBlockstateTemplates.TRAPDOOR_BLOCK, BddBlockModelTemplates.TRAPDOOR, BddItemModelTemplates.BLOCK_SPRITE);
        this.generate(modId, blockName + "_fence_gate", BddBlockstateTemplates.FENCE_GATE_BLOCK, BddBlockModelTemplates.FENCE_GATE, BddItemModelTemplates.BLOCK_SPRITE);
        return this;
    }

    private void generate(String modId, String blockName, BddBlockstateTemplates state, BddBlockModelTemplates model, BddItemModelTemplates item) {
        BddBlockstateGenerator.generateBlockstate(modId, blockName, state);
        BddBlockModelGenerator.generateBlockModel(modId, blockName, model);
        BddItemModelGenerator.generateItemModel(modId, blockName, item);
    }

    public BlockstateBuilder datagen() {
        return new BlockstateBuilder();
    }

    public Supplier<Block> register() {
        if (this.properties == null) {
            this.properties = BlockBehaviour.Properties.of();
        }
        Supplier<Block> blockSupplier = BddConstants.PlatformHelper.REGISTRY.registerBlock(blockName, () -> {
            Block block = (Block)this.blockConstructor.apply(this.properties);
            this.registeredBlock = block;
            return block;
        });
        if (createDefaultItem) {
            Supplier<Item> itemSupplier = () -> new BlockItem(this.registeredBlock, new Item.Properties());
            BddConstants.PlatformHelper.REGISTRY.registerItem(blockName, itemSupplier);
        }
        REGISTERED_BUILDERS.add(this);
        return blockSupplier;
    }

    public static void doBlockModelGen() {
        if (createDefaultItem) {
            BddItemModelGenerator.generateItemModel("bdd", blockName, BddItemModelTemplates.BLOCK_ITEM);
        }
        if (blockstateTemplate != null) {
            BddBlockstateGenerator.generateBlockstate("bdd", blockName, blockstateTemplate);
            BddBlockModelGenerator.generateBlockModel("bdd", blockName, blockModelTemplate);
        }
    }

    public BlockEntityBuilder blockEntity(BlockEntityType.BlockEntitySupplier<? extends BlockEntity> factory) {
        this.blockEntityFactory = factory;
        return new BlockEntityBuilder();
    }

    public static Supplier<BlockEntityType<? extends BlockEntity>> getBlockEntityTypeSupplier() {
        return blockEntityTypeSupplier;
    }

    static {
        createDefaultItem = false;
    }

    public class BlockstateBuilder {
        public BlockstateBuilder blockstate(BddBlockstateTemplates blockstates) {
            blockstateTemplate = blockstates;
            return this;
        }

        public BlockstateBuilder model(BddBlockModelTemplates models) {
            blockModelTemplate = models;
            return this;
        }

        public BddBlockBuilder<T> finish() {
            return BddBlockBuilder.this;
        }
    }

    public class BlockEntityBuilder {
        public BlockEntityBuilder renderer(Supplier<BlockEntityRendererProvider<?>> renderer) {
            BddBlockBuilder.this.rendererProvider = renderer;
            return this;
        }

        public BddBlockBuilder<T> finish() {
            if (BddBlockBuilder.this.blockEntityFactory != null) {
                BddBlockBuilder.this.blockEntityType = BddConstants.PlatformHelper.REGISTRY.registerBlockEntity(blockName, () -> BlockEntityType.Builder.of(BddBlockBuilder.this.blockEntityFactory, (Block[])new Block[]{BddBlockBuilder.this.registeredBlock}).build(null));
                if (BddBlockBuilder.this.rendererProvider != null) {
                    BddClient.queueRenderer((entityConsumer, blockConsumer) -> blockConsumer.accept(BddBlockBuilder.this.blockEntityType.get(), BddBlockBuilder.this.rendererProvider.get()));
                }
            }
            return BddBlockBuilder.this;
        }
    }
}

