/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.blocks;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BddBlockEntityBuilder<T extends BlockEntity> {
    public static final List<BddBlockEntityBuilder<?>> REGISTERED_BUILDERS = new ArrayList();
    private final String name;
    private final BlockEntityType.BlockEntitySupplier<T> blockEntityFactory;
    private Supplier<BlockEntityRendererProvider<T>> rendererProvider;
    private Supplier<BlockEntityType<T>> blockEntityType;
    private List<Supplier<Block>> validBlockSuppliers;

    public BddBlockEntityBuilder(String name, BlockEntityType.BlockEntitySupplier<T> blockEntityFactory) {
        this.name = name;
        this.blockEntityFactory = blockEntityFactory;
        this.validBlockSuppliers = new ArrayList<Supplier<Block>>();
    }

    public static <T extends BlockEntity> BddBlockEntityBuilder<T> blockEntity(String name, BlockEntityType.BlockEntitySupplier<T> factory) {
        return new BddBlockEntityBuilder<T>(name, factory);
    }

    public BddBlockEntityBuilder<T> validBlocks(Supplier<Block> ... blockSuppliers) {
        this.validBlockSuppliers = Arrays.asList(blockSuppliers);
        return this;
    }

    public BddBlockEntityBuilder<T> renderer(BlockEntityRendererProvider<T> renderer) {
        this.rendererProvider = () -> renderer;
        return this;
    }

    public Supplier<BlockEntityType<T>> register() {
        Supplier blockEntityTypeSupplier = BddConstants.PlatformHelper.REGISTRY.registerBlockEntity(this.name, () -> {
            Block[] blocks = (Block[])this.validBlockSuppliers.stream().map(Supplier::get).toArray(Block[]::new);
            BlockEntityType type = BlockEntityType.Builder.of(this.blockEntityFactory, (Block[])blocks).build(null);
            this.blockEntityType = () -> type;
            return type;
        });
        if (this.rendererProvider != null) {
            BddClient.queueRenderer((entityConsumer, blockConsumer) -> blockConsumer.accept(this.blockEntityType.get(), this.rendererProvider.get()));
        }
        REGISTERED_BUILDERS.add(this);
        return blockEntityTypeSupplier;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<BlockEntityType<T>> getBlockEntityType() {
        return this.blockEntityType;
    }
}

