/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.entity;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class BddProjectileBuilder<T extends Entity> {
    private final String name;
    private final EntityType.EntityFactory<T> factory;
    private final MobCategory category;
    private final Class<T> entityClass;
    private float width;
    private float height;
    private EntityRendererProvider<T> rendererProvider = null;

    public BddProjectileBuilder(String name, EntityType.EntityFactory<T> factory, MobCategory category, Class<T> entityClass) {
        this.name = name;
        this.factory = factory;
        this.category = category;
        this.entityClass = entityClass;
    }

    public BddProjectileBuilder<T> sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public BddProjectileBuilder<T> renderer(EntityRendererProvider<T> rendererProvider) {
        this.rendererProvider = rendererProvider;
        return this;
    }

    public Supplier<EntityType<T>> register() {
        Supplier entityTypeSupplier = BddConstants.PlatformHelper.REGISTRY.registerEntity(this.name, () -> EntityType.Builder.of(this.factory, (MobCategory)this.category).sized(this.width, this.height).build(this.name));
        if (this.rendererProvider != null) {
            BddClient.queueRenderer((entityConsumer, blockConsumer) -> entityConsumer.accept((EntityType)entityTypeSupplier.get(), this.rendererProvider));
        }
        return entityTypeSupplier;
    }
}

