/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.items;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.registry.helpers.items.ArmorSetConfig;
import com.bdc.bdd.registry.helpers.items.BddItemModelGenerator;
import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import com.bdc.bdd.registry.helpers.items.ToolsetConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class BddItemBuilder<T extends Item> {
    public static final List<String> generatedItems = new ArrayList<String>();
    public static final Map<String, BddItemModelTemplates> customModelMap = new HashMap<String, BddItemModelTemplates>();
    public static String itemName;
    public final Function<Item.Properties, T> itemConstructor;
    public Consumer<Item.Properties> propertiesConsumer = props -> {};
    public static final Map<String, List<Supplier<Item>>> TOOLSETS;
    public static final Map<String, List<Supplier<Item>>> ARMORSETS;
    private boolean isToolset = false;
    private boolean isArmorSet = false;

    public BddItemBuilder(String name, Function<Item.Properties, T> itemConstructor) {
        itemName = name;
        this.itemConstructor = itemConstructor;
    }

    public static <T extends Item> BddItemBuilder<T> item(String name, Function<Item.Properties, T> itemConstructor) {
        return new BddItemBuilder<T>(name, itemConstructor);
    }

    public static void doItemModelGen() {
        for (String itemName : generatedItems) {
            BddItemModelTemplates template = customModelMap.getOrDefault(itemName, BddItemModelTemplates.HANDHELD);
            if (itemName.endsWith("_sword") || itemName.endsWith("_pickaxe") || itemName.endsWith("_axe") || itemName.endsWith("_shovel") || itemName.endsWith("_hoe")) {
                template = BddItemModelTemplates.HANDHELD;
            } else if (itemName.endsWith("_helmet") || itemName.endsWith("_chestplate") || itemName.endsWith("_leggings") || itemName.endsWith("_boots")) {
                template = BddItemModelTemplates.GENERATED;
            }
            BddItemModelGenerator.generateItemModel("bdd", itemName, template);
        }
    }

    public BddItemBuilder<T> properties(Consumer<Item.Properties> consumer) {
        this.propertiesConsumer = consumer;
        return this;
    }

    public BddItemBuilder<T> model(BddItemModelTemplates template) {
        customModelMap.put(itemName, template);
        return this;
    }

    private <U extends Item> Supplier<U> registerTool(String toolName, Function<Item.Properties, U> toolConstructor, Consumer<Item.Properties> toolProperties) {
        Item.Properties properties = new Item.Properties();
        this.propertiesConsumer.accept(properties);
        if (toolProperties != null) {
            toolProperties.accept(properties);
        }
        Supplier<Item> itemSupplier = () -> (Item)toolConstructor.apply(properties);
        BddConstants.PlatformHelper.REGISTRY.registerItem(toolName, itemSupplier);
        generatedItems.add(toolName);
        return itemSupplier;
    }

    public BddItemBuilder<SwordItem> sword(Consumer<Item.Properties> swordProperties, Tier tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_sword";
        this.registerTool(toolName, props -> new SwordItem(tier, props.attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed))), swordProperties);
        return this;
    }

    public BddItemBuilder<PickaxeItem> pickaxe(Consumer<Item.Properties> pickaxeProperties, Tier tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_pickaxe";
        this.registerTool(toolName, props -> new PickaxeItem(tier, props.attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed))), pickaxeProperties);
        return this;
    }

    public BddItemBuilder<AxeItem> axe(Consumer<Item.Properties> axeProperties, Tier tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_axe";
        this.registerTool(toolName, props -> new AxeItem(tier, props.attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed))), axeProperties);
        return this;
    }

    public BddItemBuilder<ShovelItem> shovel(Consumer<Item.Properties> shovelProperties, Tier tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_shovel";
        this.registerTool(toolName, props -> new ShovelItem(tier, props.attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed))), shovelProperties);
        return this;
    }

    public BddItemBuilder<HoeItem> hoe(Consumer<Item.Properties> hoeProperties, Tier tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_hoe";
        this.registerTool(toolName, props -> new HoeItem(tier, props.attributes(PickaxeItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed))), hoeProperties);
        return this;
    }

    public BddItemBuilder<T> toolset(Tier tier, ToolsetConfig config) {
        this.isToolset = true;
        if (config.swordProperties != null) {
            this.sword(config.swordProperties, tier, config.swordAttackDamage, config.swordAttackSpeed);
        }
        if (config.pickaxeProperties != null) {
            this.pickaxe(config.pickaxeProperties, tier, config.pickaxeAttackDamage, config.pickaxeAttackSpeed);
        }
        if (config.axeProperties != null) {
            this.axe(config.axeProperties, tier, config.axeAttackDamage, config.axeAttackSpeed);
        }
        if (config.shovelProperties != null) {
            this.shovel(config.shovelProperties, tier, config.shovelAttackDamage, config.shovelAttackSpeed);
        }
        if (config.hoeProperties != null) {
            this.hoe(config.hoeProperties, tier, config.hoeAttackDamage, config.hoeAttackSpeed);
        }
        TOOLSETS.put(BddItemBuilder.itemName, generatedItems.stream().map(itemName -> () -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)itemName))).collect(Collectors.toList()));
        return this;
    }

    public BddItemBuilder<ArmorItem> helmet(Consumer<Item.Properties> properties, Holder<ArmorMaterial> material) {
        String armorName = itemName + "_helmet";
        this.registerTool(armorName, props -> new ArmorItem(material, ArmorItem.Type.HELMET, props), properties);
        return this;
    }

    public BddItemBuilder<ArmorItem> chestplate(Consumer<Item.Properties> properties, Holder<ArmorMaterial> material) {
        String armorName = itemName + "_chestplate";
        this.registerTool(armorName, props -> new ArmorItem(material, ArmorItem.Type.CHESTPLATE, props), properties);
        return this;
    }

    public BddItemBuilder<ArmorItem> leggings(Consumer<Item.Properties> properties, Holder<ArmorMaterial> material) {
        String armorName = itemName + "_leggings";
        this.registerTool(armorName, props -> new ArmorItem(material, ArmorItem.Type.LEGGINGS, props), properties);
        return this;
    }

    public BddItemBuilder<ArmorItem> boots(Consumer<Item.Properties> properties, Holder<ArmorMaterial> material) {
        String armorName = itemName + "_boots";
        this.registerTool(armorName, props -> new ArmorItem(material, ArmorItem.Type.BOOTS, props), properties);
        return this;
    }

    public BddItemBuilder<T> armorSet(Holder<ArmorMaterial> material, ArmorSetConfig config) {
        this.isArmorSet = true;
        if (config.helmetProperties != null) {
            this.helmet(config.helmetProperties, material);
        }
        if (config.chestplateProperties != null) {
            this.chestplate(config.chestplateProperties, material);
        }
        if (config.leggingsProperties != null) {
            this.leggings(config.leggingsProperties, material);
        }
        if (config.bootsProperties != null) {
            this.boots(config.bootsProperties, material);
        }
        ARMORSETS.put(itemName, generatedItems.stream().map(name -> () -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)name))).collect(Collectors.toList()));
        return this;
    }

    public Supplier<Item> register() {
        Item.Properties properties = new Item.Properties();
        this.propertiesConsumer.accept(properties);
        generatedItems.add(itemName);
        Supplier<Item> itemSupplier = () -> (Item)this.itemConstructor.apply(properties);
        return BddConstants.PlatformHelper.REGISTRY.registerItem(itemName, itemSupplier);
    }

    static {
        TOOLSETS = new HashMap<String, List<Supplier<Item>>>();
        ARMORSETS = new HashMap<String, List<Supplier<Item>>>();
    }
}

