/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.helpers.blockstates;

import com.bdc.bdd.registry.helpers.blockstates.BddBlockstateTemplates;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;

public class BddBlockstateGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void generateBlockstate(String modId, String name, BddBlockstateTemplates blockstateTemplate) {
        BddBlockstateGenerator.generateBlockstate(modId, name, blockstateTemplate, Collections.emptyMap());
    }

    public static void generateBlockstate(String modId, String name, BddBlockstateTemplates blockstateTemplate, Map<String, String> properties) {
        Path blockstatePath = BddBlockstateGenerator.findProjectRoot().resolve(modId + "/blockstates/" + name + ".json");
        try {
            if (Files.exists(blockstatePath, new LinkOption[0])) {
                System.out.println("Blockstate for '" + name + "' already exists at: " + String.valueOf(blockstatePath) + ". Skipping creation.");
                return;
            }
            JsonElement blockstateJson = BddBlockstateGenerator.generateBlockstateJson(modId, name, blockstateTemplate, properties);
            Files.createDirectories(blockstatePath.getParent(), new FileAttribute[0]);
            Files.write(blockstatePath, GSON.toJson(blockstateJson).getBytes(), StandardOpenOption.CREATE_NEW);
            System.out.println("Blockstate for '" + name + "' created at: " + String.valueOf(blockstatePath));
        }
        catch (IOException e) {
            System.err.println("[ERROR]: Failed to create blockstate for '" + name + "' at " + String.valueOf(blockstatePath) + ": " + e.getMessage());
        }
    }

    private static JsonElement generateBlockstateJson(String modId, String name, BddBlockstateTemplates blockstateTemplate, Map<String, String> properties) {
        JsonObject blockstateJson = blockstateTemplate.generateBlockstate(modId, name, properties);
        System.out.println("Generated JSON for '" + modId + ":blockstates/" + name + "':\n" + GSON.toJson((JsonElement)blockstateJson));
        return blockstateJson;
    }

    public static Path findProjectRoot() {
        for (Path current = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath(); current != null; current = current.getParent()) {
            Path resources = BddBlockstateGenerator.findResourcesPath(current);
            if (resources == null) continue;
            return resources;
        }
        throw new IllegalStateException("Could not locate project root");
    }

    private static Path findResourcesPath(Path current) {
        String currentDirName;
        String[] potentialPaths;
        for (String path : potentialPaths = new String[]{"src/main/resources/assets", "common/src/main/resources/assets"}) {
            Path resources = current.resolve(path);
            if (!Files.exists(resources, new LinkOption[0]) || !Files.isDirectory(resources, new LinkOption[0])) continue;
            return resources;
        }
        String string = currentDirName = current.getFileName() != null ? current.getFileName().toString() : "";
        if (currentDirName.matches("fabric|forge|neoforge|quilt")) {
            for (String path : potentialPaths) {
                Path parentResources = current.getParent().resolve(path);
                if (!Files.exists(parentResources, new LinkOption[0]) || !Files.isDirectory(parentResources, new LinkOption[0])) continue;
                return parentResources;
            }
        }
        return null;
    }
}

