/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.helpers.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class BddItemModelTemplates {
    public static final BddItemModelTemplates BLOCK_ITEM = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.empty(), Optional.empty(), new TextureSlot[0]){

                public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    String blockName = modelLocation.getPath().replace("item/", "block/");
                    jsonObject.addProperty("parent", modelLocation.getNamespace() + ":" + blockName);
                    return jsonObject;
                }
            };
        }
    };
    public static final BddItemModelTemplates BLOCK_WITH_INVENTORY_MODEL = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.empty(), Optional.empty(), new TextureSlot[0]){

                public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    String path = modelLocation.getPath().startsWith("item/") ? modelLocation.getPath().substring(5) : modelLocation.getPath();
                    String blockName = path + "_fence_inventory";
                    jsonObject.addProperty("parent", modelLocation.getNamespace() + ":block/" + blockName);
                    return jsonObject;
                }
            };
        }
    };
    public static final BddItemModelTemplates BLOCK_SPRITE = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.of(ResourceLocation.withDefaultNamespace((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0}){

                public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("parent", "minecraft:item/generated");
                    JsonObject textures = new JsonObject();
                    ResourceLocation texture = modelGetter.getOrDefault(TextureSlot.LAYER0, ResourceLocation.fromNamespaceAndPath((String)modelLocation.getNamespace(), (String)modelLocation.getPath().replace("item/", "block/")));
                    textures.addProperty("layer0", texture.toString());
                    jsonObject.add("textures", (JsonElement)textures);
                    return jsonObject;
                }
            };
        }
    };
    public static final BddItemModelTemplates GENERATED = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.of(ResourceLocation.withDefaultNamespace((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0}){

                public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("parent", "minecraft:item/generated");
                    JsonObject textures = new JsonObject();
                    int layerCount = 0;
                    for (TextureSlot slot : modelGetter.keySet()) {
                        if (slot != TextureSlot.LAYER0 && !slot.getId().startsWith("layer")) continue;
                        textures.addProperty("layer" + layerCount, modelGetter.get(slot).toString());
                        ++layerCount;
                    }
                    if (!modelGetter.containsKey(TextureSlot.LAYER0)) {
                        textures.addProperty("layer0", modelLocation.getNamespace() + ":item/" + modelLocation.getPath().replace("item/", ""));
                    }
                    jsonObject.add("textures", (JsonElement)textures);
                    return jsonObject;
                }
            };
        }
    };
    public static final BddItemModelTemplates HANDHELD = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.of(ResourceLocation.withDefaultNamespace((String)"item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0}){

                public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("parent", "minecraft:item/handheld");
                    JsonObject textures = new JsonObject();
                    ResourceLocation texture = modelGetter.getOrDefault(TextureSlot.LAYER0, ResourceLocation.fromNamespaceAndPath((String)modelLocation.getNamespace(), (String)modelLocation.getPath()));
                    textures.addProperty("layer0", texture.toString());
                    jsonObject.add("textures", (JsonElement)textures);
                    return jsonObject;
                }
            };
        }
    };
    public static final BddItemModelTemplates SPAWN_EGG = new BddItemModelTemplates(){

        @Override
        public ModelTemplate getTemplate() {
            return new ModelTemplate(this, Optional.of(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/template_spawn_egg")), Optional.empty(), new TextureSlot[0]){

                @NotNull
                public JsonObject createBaseTemplate(@NotNull ResourceLocation modelLocation, @NotNull Map<TextureSlot, ResourceLocation> modelGetter) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("parent", "minecraft:item/template_spawn_egg");
                    return jsonObject;
                }
            };
        }
    };

    public abstract ModelTemplate getTemplate();
}

