/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.util;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.api.util.DragonAbilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class BddGuiUtils {
    public static void renderTranslucentBox(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.fill(x, y, x + width, y + height, color);
    }

    public static void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int width, int height, float progress, int emptyColor, int filledColor) {
        int filledWidth = (int)((float)width * progress);
        guiGraphics.fill(x, y, x + width, y + height, emptyColor);
        guiGraphics.fill(x, y + 1, x + filledWidth, y + height - 1, filledColor);
    }

    public static void renderProgressBarHoriz(GuiGraphics guiGraphics, int x, int y, int width, int height, float progress, int emptyColor, int filledColor) {
        int filledHeight = (int)((float)height * progress);
        guiGraphics.fill(x, y, x + width, y - height, emptyColor);
        guiGraphics.fill(x, y, x + width, y - filledHeight + 1, filledColor);
    }

    public static void renderItemIcon(GuiGraphics guiGraphics, int x, int y, Item item) {
        guiGraphics.renderItem(new ItemStack((ItemLike)item), x, y);
    }

    public static void renderBar(GuiGraphics guiGraphics, ResourceLocation sprite, ResourceLocation backSprite, int X, int Y, float value, float maxValue, int xOffset, int yOffset) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        Vec2 dimensions = new Vec2((float)X, (float)Y);
        int imageWidth = (int)((double)dimensions.x * 1.5);
        int imageHeight = (int)((double)dimensions.y * 1.5);
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.blit(backSprite, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        float barWidth = value / maxValue;
        int visibleWidth = (int)((float)imageWidth * barWidth);
        int fillX = x + (imageWidth - visibleWidth);
        guiGraphics.blit(sprite, fillX, y, (float)(imageWidth - visibleWidth), 0.0f, visibleWidth, imageHeight, imageWidth, imageHeight);
    }

    public static void renderAbilityBar(GuiGraphics guiGraphics, DragonAbilities ability, int xOffset, int yOffset, String keybind) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        Vec2 dimensions = new Vec2(26.0f, 26.0f);
        int imageWidth = (int)dimensions.x;
        int imageHeight = (int)dimensions.y;
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.blit(ability.getSprite(), x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        int textX = x + imageWidth / 2 - 2;
        int textY = y + imageHeight / 2 - 22;
        guiGraphics.drawString(Minecraft.getInstance().font, ability.getKeybind(), textX, textY, 0xFFFFFF, true);
    }

    public static int renderAbilityIfHas(GuiGraphics guiGraphics, BddAbilityDragon dragon, DragonAbilities ability, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBar(guiGraphics, ability, pos, yPos, ability.getKeybind());
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static int renderProjBarIfHas(GuiGraphics guiGraphics, ResourceLocation sprite, ResourceLocation backSprite, BddAbilityDragon dragon, DragonAbilities ability, String maxShots, float value, float maxValue, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBarWithKeybind(guiGraphics, sprite, backSprite, value, maxValue, pos, yPos, ability.getKeybind() + maxShots, true);
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static int renderBreathBarIfHas(GuiGraphics guiGraphics, ResourceLocation sprite, ResourceLocation backSprite, BddAbilityDragon dragon, DragonAbilities ability, float value, float maxValue, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBarWithKeybind(guiGraphics, sprite, backSprite, value, maxValue, pos, yPos, ability.getKeybind(), false);
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static void renderAbilityBarWithKeybind(GuiGraphics guiGraphics, ResourceLocation sprite, ResourceLocation backSprite, float value, float maxValue, int xOffset, int yOffset, String keybind, boolean fillBottomToTop) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int imageWidth = 26;
        int imageHeight = 26;
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.blit(backSprite, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        float barHeight = value / maxValue;
        int visibleHeight = (int)((float)imageHeight * barHeight);
        if (fillBottomToTop) {
            int fillY = y + (imageHeight - visibleHeight);
            guiGraphics.blit(sprite, x, fillY, 0.0f, (float)(imageHeight - visibleHeight), imageWidth, visibleHeight, imageWidth, imageHeight);
        } else {
            guiGraphics.blit(sprite, x, y, 0.0f, 0.0f, imageWidth, visibleHeight, imageWidth, imageHeight);
        }
        int textX = x + imageWidth / 2 - Minecraft.getInstance().font.width(keybind) / 2;
        int textY = y - 10;
        guiGraphics.drawString(Minecraft.getInstance().font, keybind, textX, textY, 0xFFFFFF, true);
    }
}

