/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibCommon;
import software.bluelib.client.BlueLibClient;
import software.bluelib.config.ConfigHolder;
import software.bluelib.event.NeoForgeReloadHandler;
import software.bluelib.example.event.VariantProvider;
import software.bluelib.net.NeoForgeNetworkManager;
import software.bluelib.platform.NeoForgeRegistryHelper;

@Mod(value="bluelib")
public class BlueLib {
    public BlueLib(@NotNull IEventBus pModEventBus, @NotNull ModContainer pModContainer) {
        NeoForgeRegistryHelper.register(pModEventBus);
        BlueLibCommon.doRegistration();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            BlueLibClient.init(pModContainer);
        }
        this.registerConfigs(pModContainer);
        this.setupEventListeners(pModEventBus);
        NeoForgeReloadHandler.registerProvider(new VariantProvider());
    }

    private void registerConfigs(@NotNull ModContainer pModContainer) {
        pModContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHolder.MARKDOWN_SPEC, "bluelib-markdown.toml");
        pModContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHolder.LOGGER_SPEC, "bluelib-logger.toml");
    }

    private void setupEventListeners(@NotNull IEventBus pModEventBus) {
        pModEventBus.register((Object)this);
        pModEventBus.addListener(NeoForgeNetworkManager::registerMessages);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLoadComplete(@NotNull InterModProcessEvent pEvent) {
        BlueLibCommon.init();
    }
}

