/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.entity.variant;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.api.utils.variant.ParameterUtils;
import software.bluelib.entity.variant.IVariantAccessor;
import software.bluelib.internal.BlueTranslation;

public interface IVariantEntity<T extends Entity> {
    @NotNull
    public static final RandomSource random = RandomSource.create();

    @NotNull
    public T getEntity();

    @NotNull
    default public String getRandomVariant(@NotNull List<String> pVariantNamesList, @NotNull String pDefaultVariant) {
        if (pVariantNamesList.isEmpty()) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("variant.list.empty", pDefaultVariant));
            return pDefaultVariant;
        }
        int index = random.nextInt(pVariantNamesList.size());
        String selectedVariant = pVariantNamesList.get(index);
        BaseLogger.log((Boolean)true, BaseLogLevel.SUCCESS, BlueTranslation.log("variant.random", selectedVariant, pVariantNamesList.size()));
        return selectedVariant;
    }

    @Nullable
    default public List<String> getEntityVariants(@NotNull ResourceLocation pEntity) {
        Set<String> variants = ParameterUtils.getVariantsOfEntity(pEntity);
        return variants != null ? new ArrayList<String>(variants) : null;
    }

    @NotNull
    default public String getVariantName() {
        T entity = this.getEntity();
        return ((IVariantAccessor)entity).getEntityVariantName();
    }

    default public void setVariantName(@NotNull String pVariantName) {
        T entity = this.getEntity();
        ((IVariantAccessor)entity).setEntityVariantName(pVariantName);
    }
}

