/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.event;

import java.util.List;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.event.BlueRenderEvent;
import software.bluelib.api.event.IEventProxy;
import software.bluelib.api.event.entity.AllVariantsLoadedEvent;
import software.bluelib.api.event.entity.VariantLoadedEvent;
import software.bluelib.api.event.mod.AllModsLoadedEvent;
import software.bluelib.api.event.mod.ModLoadedEvent;
import software.bluelib.api.event.mod.ModMeta;
import software.bluelib.loader.renderer.BlueObjectRenderer;
import software.bluelib.loader.renderer.armor.BlueArmorRenderer;
import software.bluelib.loader.renderer.block.BlueBlockRenderer;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.BlueEntityRenderer;
import software.bluelib.loader.renderer.entity.BlueReplacedEntityRenderer;
import software.bluelib.loader.renderer.item.BlueItemRenderer;

public class BlueLibEventProxy
implements IEventProxy {
    @Override
    public void onModLoaded(@NotNull ModMeta pModData) {
        ModLoader.postEvent((Event)new ModLoadedEvent(pModData));
    }

    @Override
    public void onAllModsLoaded(@NotNull List<ModMeta> pModData) {
        ModLoader.postEvent((Event)new AllModsLoadedEvent(pModData));
    }

    @Override
    @NotNull
    public Boolean variantLoadedPre(@NotNull String pEntityName, @NotNull String pVariant) {
        VariantLoadedEvent.Pre event = new VariantLoadedEvent.Pre(pEntityName, pVariant);
        return ((VariantLoadedEvent.Pre)ModLoader.postEventWithReturn((Event)event)).isCanceled();
    }

    @Override
    public void variantLoadedPost(@NotNull String pEntityName, @NotNull String pVariant) {
        ModLoader.postEvent((Event)new VariantLoadedEvent.Post(pEntityName, pVariant));
    }

    @Override
    @NotNull
    public Boolean allVariantsLoadedPre(@NotNull String pEntityName) {
        AllVariantsLoadedEvent.Pre event = new AllVariantsLoadedEvent.Pre(pEntityName);
        return ((AllVariantsLoadedEvent.Pre)ModLoader.postEventWithReturn((Event)event)).isCanceled();
    }

    @Override
    public void allVariantsLoadedPost(@NotNull String pEntityName) {
        ModLoader.postEvent((Event)new AllVariantsLoadedEvent.Post(pEntityName));
    }

    @Override
    public void fireCompileBlockRenderLayers(@NotNull BlueBlockRenderer<?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Block.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireBlockPreRender(@NotNull BlueBlockRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.Block.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Block.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireBlockPostRender(@NotNull BlueBlockRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Block.Post(pRenderer, pContext));
    }

    @Override
    public void fireCompileArmorRenderLayers(@NotNull BlueArmorRenderer<?, ?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Armor.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireArmorPreRender(@NotNull BlueArmorRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.Armor.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Armor.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireArmorPostRender(@NotNull BlueArmorRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Armor.Post(pRenderer, pContext));
    }

    @Override
    public void fireCompileEntityRenderLayers(@NotNull BlueEntityRenderer<?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Entity.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireEntityPreRender(@NotNull BlueEntityRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.Entity.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Entity.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireEntityPostRender(@NotNull BlueEntityRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Entity.Post(pRenderer, pContext));
    }

    @Override
    public void fireCompileReplacedEntityRenderLayers(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.ReplacedEntity.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireReplacedEntityPreRender(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.ReplacedEntity.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.ReplacedEntity.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireReplacedEntityPostRender(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.ReplacedEntity.Post(pRenderer, pContext));
    }

    @Override
    public void fireCompileItemRenderLayers(@NotNull BlueItemRenderer<?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Item.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireItemPreRender(@NotNull BlueItemRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.Item.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Item.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireItemPostRender(@NotNull BlueItemRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Item.Post(pRenderer, pContext));
    }

    @Override
    public void fireCompileObjectRenderLayers(@NotNull BlueObjectRenderer<?> pRenderer) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Object.CompileRenderLayers(pRenderer));
    }

    @Override
    @NotNull
    public Boolean fireObjectPreRender(@NotNull BlueObjectRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        return !((BlueRenderEvent.Object.Pre)NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Object.Pre(pRenderer, pContext))).isCanceled();
    }

    @Override
    public void fireObjectPostRender(@NotNull BlueObjectRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
        NeoForge.EVENT_BUS.post((Event)new BlueRenderEvent.Object.Post(pRenderer, pContext));
    }
}

