/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.exception;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class CompoundException
extends RuntimeException {
    @NotNull
    private final List<String> messages = new ObjectArrayList();

    public CompoundException(@NotNull String pMessage) {
        this.messages.add(pMessage);
    }

    @NotNull
    public CompoundException withMessage(@NotNull String pMessage) {
        this.messages.add(pMessage);
        return this;
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        int count;
        StringJoiner joiner = new StringJoiner("\n");
        for (int i = count = this.messages.size() - 1; i >= 0; --i) {
            joiner.add((String)(i == count ? "" : "\t".repeat(Math.max(0, count - i)) + "-> ") + this.messages.get(i));
        }
        return joiner.toString();
    }

    @Override
    @NotNull
    public String toString() {
        String name = "BlueLib.CompoundException";
        String message = this.getLocalizedMessage();
        return "BlueLib.CompoundException: " + message;
    }
}

