/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class JSONMerger {
    public static void mergeJsonObjects(@NotNull JsonObject pTarget, @NotNull JsonObject pSource) {
        for (Map.Entry entry : pSource.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement sourceElement = (JsonElement)entry.getValue();
            if (pTarget.has(key)) {
                JsonElement targetElement = pTarget.get(key);
                if (targetElement.isJsonArray() && sourceElement.isJsonArray()) {
                    JsonArray targetArray = targetElement.getAsJsonArray();
                    JsonArray sourceArray = sourceElement.getAsJsonArray();
                    for (JsonElement element : sourceArray) {
                        targetArray.add(element);
                    }
                    BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("json.merge", key));
                    continue;
                }
                pTarget.add(key, sourceElement);
                BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("json.overwrite", key));
                continue;
            }
            pTarget.add(key, sourceElement);
            BaseLogger.log((Boolean)true, BaseLogLevel.SUCCESS, BlueTranslation.log("json.add", key));
        }
    }
}

