/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.color;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.awt.Color;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.color.RGBAColor;

public record RGBAColorCache(@NotNull Integer red, @NotNull Integer green, @NotNull Integer blue, @NotNull Integer alpha) {
    public static final Codec<RGBAColorCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)RGBAColorCache.readFromNBT(tag));
    }, colorCache -> {
        CompoundTag tag = new CompoundTag();
        colorCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<RGBAColorCache> RGBA_COLOR_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putInt("Red", this.red.intValue());
        pTag.putInt("Green", this.green.intValue());
        pTag.putInt("Blue", this.blue.intValue());
        pTag.putInt("Alpha", this.alpha.intValue());
    }

    @NotNull
    public static RGBAColorCache readFromNBT(@NotNull CompoundTag pTag) {
        return new RGBAColorCache(pTag.getInt("Red"), pTag.getInt("Green"), pTag.getInt("Blue"), pTag.getInt("Alpha"));
    }

    @NotNull
    public static RGBAColorCache construct(@NotNull RGBAColor pColor) {
        return new RGBAColorCache(pColor.red(), pColor.green(), pColor.blue(), pColor.alpha());
    }

    public static Color convert(@NotNull RGBAColor pColor) {
        return new Color(pColor.red(), pColor.green(), pColor.blue(), pColor.alpha());
    }

    public static Color convert(@NotNull RGBAColorCache pColor) {
        return new Color(pColor.red(), pColor.green(), pColor.blue(), pColor.alpha());
    }
}

