/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.color;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.awt.Color;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.color.RGBColor;

public record RGBColorCache(@NotNull Integer red, @NotNull Integer green, @NotNull Integer blue) {
    public static final Codec<RGBColorCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)RGBColorCache.readFromNBT(tag));
    }, colorCache -> {
        CompoundTag tag = new CompoundTag();
        colorCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<RGBColorCache> RGB_COLOR_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putInt("Red", this.red.intValue());
        pTag.putInt("Green", this.green.intValue());
        pTag.putInt("Blue", this.blue.intValue());
    }

    @NotNull
    public static RGBColorCache readFromNBT(@NotNull CompoundTag pTag) {
        return new RGBColorCache(pTag.getInt("Red"), pTag.getInt("Green"), pTag.getInt("Blue"));
    }

    @NotNull
    public static RGBColorCache construct(@NotNull RGBColor pColor) {
        return new RGBColorCache(pColor.red(), pColor.green(), pColor.blue());
    }

    public static Color convert(@NotNull RGBColor pColor) {
        return new Color(pColor.red(), pColor.green(), pColor.blue());
    }

    public static Color convert(@NotNull RGBColorCache pColor) {
        return new Color(pColor.red(), pColor.green(), pColor.blue());
    }
}

