/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.pos;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bluelib.api.json.deserializer.pos.Vector3;

public record Vector3Cache(@NotNull Float x, @NotNull Float y, @NotNull Float z) {
    public static final Codec<Vector3Cache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)Vector3Cache.readFromNBT(tag));
    }, vector3Cache -> {
        CompoundTag tag = new CompoundTag();
        vector3Cache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<Vector3Cache> VECTOR3_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putFloat("x", this.x.floatValue());
        pTag.putFloat("y", this.y.floatValue());
        pTag.putFloat("z", this.z.floatValue());
    }

    @NotNull
    public static Vector3Cache readFromNBT(@NotNull CompoundTag pTag) {
        return new Vector3Cache(Float.valueOf(pTag.getFloat("x")), Float.valueOf(pTag.getFloat("y")), Float.valueOf(pTag.getFloat("z")));
    }

    @NotNull
    public static Vector3Cache construct(@NotNull Vector3 pVectorRange) {
        return new Vector3Cache(pVectorRange.x(), pVectorRange.y(), pVectorRange.z());
    }

    public static Vector3f convert(@NotNull Vector3 pVector) {
        return new Vector3f(pVector.x().floatValue(), pVector.y().floatValue(), pVector.z().floatValue());
    }

    public static Vector3f convert(@NotNull Vector3Cache pVector) {
        return new Vector3f(pVector.x().floatValue(), pVector.y().floatValue(), pVector.z().floatValue());
    }
}

