/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.FloatRange;

public record FloatRangeCache(@NotNull Float min, @NotNull Float max) {
    public static final Codec<FloatRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)FloatRangeCache.readFromNBT(tag));
    }, floatRangeCache -> {
        CompoundTag tag = new CompoundTag();
        floatRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<FloatRangeCache> FLOAT_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putFloat("Min", this.min.floatValue());
        pTag.putFloat("Max", this.max.floatValue());
    }

    @NotNull
    public static FloatRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new FloatRangeCache(Float.valueOf(pTag.getFloat("Min")), Float.valueOf(pTag.getFloat("Max")));
    }

    @NotNull
    public static FloatRangeCache construct(@NotNull FloatRange pFloatRange) {
        return new FloatRangeCache(pFloatRange.min(), pFloatRange.max());
    }
}

