/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.IntRange;

public record IntRangeCache(@NotNull Integer min, @NotNull Integer max) {
    public static final Codec<IntRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)IntRangeCache.readFromNBT(tag));
    }, intRangeCache -> {
        CompoundTag tag = new CompoundTag();
        intRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<IntRangeCache> INT_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putInt("Min", this.min.intValue());
        pTag.putInt("Max", this.max.intValue());
    }

    @NotNull
    public static IntRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new IntRangeCache(pTag.getInt("Min"), pTag.getInt("Max"));
    }

    @NotNull
    public static IntRangeCache construct(@NotNull IntRange pIntRange) {
        return new IntRangeCache(pIntRange.min(), pIntRange.max());
    }
}

