/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.ShortRange;

public record ShortRangeCache(@NotNull Short min, @NotNull Short max) {
    public static final Codec<ShortRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)ShortRangeCache.readFromNBT(tag));
    }, shortRangeCache -> {
        CompoundTag tag = new CompoundTag();
        shortRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    public static final DataComponentType<ShortRangeCache> SHORT_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putShort("Min", this.min.shortValue());
        pTag.putShort("Max", this.max.shortValue());
    }

    @NotNull
    public static ShortRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new ShortRangeCache(pTag.getShort("Min"), pTag.getShort("Max"));
    }

    @NotNull
    public static ShortRangeCache construct(@NotNull ShortRange pShortRange) {
        return new ShortRangeCache(pShortRange.min(), pShortRange.max());
    }
}

