/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.entity;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.molang.context.BaseMoLangContext;

public class LeashableMoLang
extends BaseMoLangContext {
    public LeashableMoLang(@NotNull Supplier<Leashable> pLeashableSup) {
        Leashable leashableEntity = pLeashableSup.get();
        this.setVariable("leash_tag", "leash");
        this.setVariable("leash_too_far_dist", 10.0);
        this.setVariable("leash_elastic_dist", 6.0);
        this.setVariable("get_leash_data", leashableEntity.getLeashData());
        this.setVariable("is_leashed", leashableEntity.isLeashed());
        this.setVariable("can_have_a_leash_attached_to_it", leashableEntity.canHaveALeashAttachedToIt());
        this.setVariable("can_be_leashed", leashableEntity.canBeLeashed());
        this.setVariable("get_leash_holder", leashableEntity.getLeashHolder());
        this.registerFunction("set_leash_data", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Leashable.LeashData)) {
                return leashableEntity.getLeashData();
            }
            Leashable.LeashData data = (Leashable.LeashData)patt0$temp;
            leashableEntity.setLeashData(data);
            return leashableEntity.getLeashData();
        });
        this.registerFunction("set_delayed_leash_holder_id", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Integer)) {
                return false;
            }
            Integer data = (Integer)patt0$temp;
            leashableEntity.setDelayedLeashHolderId(data.intValue());
            return true;
        });
        this.registerFunction("read_leash_data", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof CompoundTag)) {
                return false;
            }
            CompoundTag data = (CompoundTag)patt0$temp;
            return leashableEntity.readLeashData(data);
        });
        this.registerFunction("write_leash_data", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof CompoundTag) && !(args.get(1) instanceof Leashable.LeashData)) {
                return false;
            }
            CompoundTag data = (CompoundTag)args.getFirst();
            Leashable.LeashData leashData = (Leashable.LeashData)args.get(1);
            leashableEntity.writeLeashData(data, leashData);
            return leashableEntity.readLeashData(data);
        });
        this.registerFunction("drop_leash", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof Boolean) && !(args.get(1) instanceof Boolean)) {
                return false;
            }
            boolean sendPacket = (Boolean)args.getFirst();
            boolean dropItem = (Boolean)args.get(1);
            leashableEntity.dropLeash(sendPacket, dropItem);
            return true;
        });
        this.registerFunction("handle_leash_at_distance", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof Entity) && !(args.get(1) instanceof Number)) {
                return false;
            }
            Entity entity = (Entity)args.getFirst();
            float distance = ((Number)args.get(1)).floatValue();
            leashableEntity.handleLeashAtDistance(entity, distance);
            return true;
        });
        this.registerFunction("leash_too_far_behaviour", (args, runtime) -> {
            leashableEntity.leashTooFarBehaviour();
            return true;
        });
        this.registerFunction("close_range_leash_behaviour", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Entity)) {
                return false;
            }
            Entity entity = (Entity)patt0$temp;
            leashableEntity.closeRangeLeashBehaviour(entity);
            return true;
        });
        this.registerFunction("elastic_range_leash_behaviour", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof Entity) && !(args.get(1) instanceof Number)) {
                return false;
            }
            Entity entity = (Entity)args.getFirst();
            float distance = ((Number)args.get(1)).floatValue();
            leashableEntity.elasticRangeLeashBehaviour(entity, distance);
            return true;
        });
        this.registerFunction("set_leash_to", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof Entity) && !(args.get(1) instanceof Boolean)) {
                return false;
            }
            Entity entity = (Entity)args.getFirst();
            boolean broadcast = (Boolean)args.get(1);
            leashableEntity.setLeashedTo(entity, broadcast);
            return true;
        });
    }
}

