/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.entity.animal;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.molang.context.BaseMoLangContext;

public class AnimalMoLang
extends BaseMoLangContext {
    public AnimalMoLang(@NotNull Supplier<Animal> pAnimalSup) {
        Animal animal = pAnimalSup.get();
        this.setVariable("is_in_love", animal.isInLove());
        this.setVariable("can_fall_in_love", animal.canFallInLove());
        this.setVariable("get_ambient_sound_interval", animal.getAmbientSoundInterval());
        this.setVariable("get_love_cause", animal.getLoveCause());
        this.registerFunction("check_animal_spawn_rules", (args, runtime) -> {
            if (!(args.size() == 5 && (args.getFirst() instanceof EntityType || args.get(1) instanceof LevelAccessor || args.get(2) instanceof MobSpawnType || args.get(3) instanceof BlockPos || args.get(4) instanceof RandomSource))) {
                return false;
            }
            EntityType entityType = (EntityType)args.getFirst();
            LevelAccessor levelAccessor = (LevelAccessor)args.get(1);
            MobSpawnType mobSpawnType = (MobSpawnType)args.get(2);
            BlockPos blockPos = (BlockPos)args.get(3);
            RandomSource randomSource = (RandomSource)args.get(4);
            return Animal.checkAnimalSpawnRules((EntityType)entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
        });
        this.registerFunction("remove_when_far_away", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Number)) {
                return false;
            }
            Number distance = (Number)patt0$temp;
            double distanceToClosestPlayer = distance.doubleValue();
            return animal.removeWhenFarAway(distanceToClosestPlayer);
        });
        this.registerFunction("is_food", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof ItemStack)) {
                return false;
            }
            ItemStack item = (ItemStack)patt0$temp;
            return animal.isFood(item);
        });
        this.registerFunction("set_in_love", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Player)) {
                return animal.isInLove();
            }
            Player player = (Player)patt0$temp;
            animal.setInLove(player);
            return animal.isInLove();
        });
        this.registerFunction("set_in_love_time", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Number)) {
                return animal.getInLoveTime();
            }
            Number time = (Number)patt0$temp;
            int inLoveTime = time.intValue();
            animal.setInLoveTime(inLoveTime);
            return animal.getInLoveTime();
        });
        this.registerFunction("reset_love", (args, runtime) -> {
            animal.resetLove();
            return true;
        });
        this.registerFunction("can_mate", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Animal)) {
                return false;
            }
            Animal mate = (Animal)patt0$temp;
            return animal.canMate(mate);
        });
        this.registerFunction("spawn_child_from_breeding", (args, runtime) -> {
            if (args.size() != 1 || !(args.getFirst() instanceof ServerLevel) && !(args.get(1) instanceof Animal)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)args.getFirst();
            Animal mate = (Animal)args.get(1);
            animal.spawnChildFromBreeding(serverLevel, mate);
            return true;
        });
        this.registerFunction("finalize_spawn_child_from_breeding", (args, runtime) -> {
            if (args.size() != 1 || !(args.getFirst() instanceof ServerLevel) && !(args.get(1) instanceof Animal) && !(args.get(2) instanceof AgeableMob)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)args.getFirst();
            Animal mate = (Animal)args.get(1);
            AgeableMob child = (AgeableMob)args.get(2);
            animal.finalizeSpawnChildFromBreeding(serverLevel, mate, child);
            return true;
        });
    }
}

