/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.entity.animal;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Bee;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.molang.context.BaseMoLangContext;

public class BeeMoLang
extends BaseMoLangContext {
    public BeeMoLang(@NotNull Supplier<Bee> pBeeSup) {
        Bee bee = pBeeSup.get();
        this.setVariable("flap_degrees_per_tick", Float.valueOf(120.32113f));
        this.setVariable("ticks_per_flap", Bee.TICKS_PER_FLAP);
        this.setVariable("tag_crops_grown_since_pollination", "CropsGrownSincePollination");
        this.setVariable("tag_cannot_enter_hive_ticks", "CannotEnterHiveTicks");
        this.setVariable("tag_ticks_since_pollination", "TicksSincePollination");
        this.setVariable("tag_has_stung", "HasStung");
        this.setVariable("tag_has_nectar", "HasNectar");
        this.setVariable("tag_flower_pos", "flower_pos");
        this.setVariable("tag_hive_pos", "hive_pos");
        this.setVariable("get_saved_flower_pos", bee.getSavedFlowerPos());
        this.setVariable("has_saved_flower_pos", bee.hasSavedFlowerPos());
        this.setVariable("get_travelling_ticks", bee.getTravellingTicks());
        this.setVariable("get_blacklisted_hives", bee.getBlacklistedHives());
        this.setVariable("has_hive", bee.hasHive());
        this.setVariable("get_hive_pos", bee.getHivePos());
        this.setVariable("get_goal_selector", bee.getGoalSelector());
        this.setVariable("has_nectar", bee.hasNectar());
        this.setVariable("has_stung", bee.hasStung());
        this.registerFunction("set_saved_flower_pos", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof BlockPos)) {
                return bee.getSavedFlowerPos();
            }
            BlockPos pos = (BlockPos)patt0$temp;
            bee.setSavedFlowerPos(pos);
            return bee.getSavedFlowerPos();
        });
        this.registerFunction("set_stay_out_of_hive_countdown", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Number)) {
                return false;
            }
            Number hiveCooldown = (Number)patt0$temp;
            int cooldown = hiveCooldown.intValue();
            bee.setStayOutOfHiveCountdown(cooldown);
            return true;
        });
        this.registerFunction("get_roll_amount", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Number)) {
                return 0.0;
            }
            Number tick = (Number)patt0$temp;
            float partialTick = tick.floatValue();
            return Float.valueOf(bee.getRollAmount(partialTick));
        });
        this.registerFunction("reset_ticks_without_nectar_since_exiting_hive", (args, runtime) -> {
            bee.resetTicksWithoutNectarSinceExitingHive();
            return true;
        });
    }
}

