/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.random.PityRandom;

@ApiStatus.Experimental
public class HardPityRandom<T>
extends PityRandom<T> {
    @NotNull
    private final Integer hardPity;
    @NotNull
    private Integer attempts = 0;

    public HardPityRandom(@NotNull Collection<T> pValues, @NotNull Integer pHardPity) {
        super(pValues);
        this.hardPity = pHardPity;
    }

    @NotNull
    public static HardPityRandom<Double> ofRange(@NotNull Double pMin, @NotNull Double pMax, @NotNull Double pStep) {
        return HardPityRandom.ofRange(pMin, pMax, pStep, pMax.intValue());
    }

    @NotNull
    public static HardPityRandom<Double> ofRange(@NotNull Double pMax, @NotNull Double pStep, @NotNull Integer pHardPity) {
        return HardPityRandom.ofRange(0.0, pMax, pStep, pHardPity);
    }

    @NotNull
    public static HardPityRandom<Double> ofRange(@NotNull Double pMax, @NotNull Double pStep) {
        return HardPityRandom.ofRange(0.0, pMax, pStep, pMax.intValue());
    }

    @NotNull
    public static HardPityRandom<Double> ofRange(@NotNull Double pMin, @NotNull Double pMax, @NotNull Double pStep, @NotNull Integer pHardPity) {
        return new HardPityRandom<Double>(HardPityRandom.buildRange(pMin, pMax, pStep), pHardPity);
    }

    @NotNull
    private static List<Double> buildRange(@NotNull Double pStart, @NotNull Double pEnd, @NotNull Double pStep) {
        ArrayList<Double> range = new ArrayList<Double>();
        for (double d = pStart.doubleValue(); d <= pEnd + 1.0E-9; d += pStep.doubleValue()) {
            range.add((double)Math.round(d * 1000000.0) / 1000000.0);
        }
        return range;
    }

    @Override
    @NotNull
    public T nextValue() {
        long stillMin;
        Integer n = this.attempts;
        this.attempts = this.attempts + 1;
        if (this.hardPity > 0 && this.attempts >= this.hardPity) {
            this.attempts = 0;
            Object leastPicked = this.selectionCounts.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(this.values.getFirst());
            this.selectionCounts.put(leastPicked, (Integer)this.selectionCounts.get(leastPicked) + 1);
            this.resetCounts();
            return (T)leastPicked;
        }
        Object value = super.nextValue();
        int minCount = this.selectionCounts.values().stream().min(Integer::compareTo).orElse(0);
        if ((Integer)this.selectionCounts.get(value) == minCount + 1 && (stillMin = this.selectionCounts.values().stream().filter(c -> c == minCount).count()) == 0L) {
            this.resetCounts();
            this.attempts = 0;
        }
        return value;
    }
}

