/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils;

import org.jetbrains.annotations.NotNull;

public record Color(int argbInt) {
    @NotNull
    public static final Color WHITE = new Color(-1);
    @NotNull
    public static final Color LIGHT_GRAY = new Color(-4144960);
    @NotNull
    public static final Color GRAY = new Color(-8355712);
    @NotNull
    public static final Color DARK_GRAY = new Color(-12566464);
    @NotNull
    public static final Color BLACK = new Color(-16777216);
    @NotNull
    public static final Color RED = new Color(-65536);
    @NotNull
    public static final Color PINK = new Color(-20561);
    @NotNull
    public static final Color ORANGE = new Color(-14336);
    @NotNull
    public static final Color YELLOW = new Color(-256);
    @NotNull
    public static final Color GREEN = new Color(-16711936);
    @NotNull
    public static final Color MAGENTA = new Color(-65281);
    @NotNull
    public static final Color CYAN = new Color(-16711681);
    @NotNull
    public static final Color BLUE = new Color(-16776961);

    @NotNull
    public static Color ofOpaque(@NotNull Integer pColor) {
        return new Color(0xFF000000 | pColor);
    }

    @NotNull
    public static Color ofRGB(@NotNull Float pRed, @NotNull Float pGreen, @NotNull Float pBlue) {
        return Color.ofRGBA(pRed, pGreen, pBlue, Float.valueOf(1.0f));
    }

    @NotNull
    public static Color ofRGB(@NotNull Integer pRed, Integer pGreen, @NotNull Integer pBlue) {
        return Color.ofRGBA(pRed, pGreen, pBlue, 255);
    }

    @NotNull
    public static Color ofRGBA(@NotNull Float pRed, @NotNull Float pGreen, @NotNull Float pBlue, @NotNull Float pA) {
        return Color.ofRGBA((int)((double)(pRed.floatValue() * 255.0f) + 0.5), (int)(pGreen.floatValue() * 255.0f + 0.5f), (int)(pBlue.floatValue() * 255.0f + 0.5f), (int)(pA.floatValue() * 255.0f + 0.5f));
    }

    @NotNull
    public static Color ofRGBA(@NotNull Integer pRed, @NotNull Integer pGreen, @NotNull Integer pBlue, @NotNull Integer pA) {
        return new Color((pA & 0xFF) << 24 | (pRed & 0xFF) << 16 | (pGreen & 0xFF) << 8 | pBlue & 0xFF);
    }

    @NotNull
    public static Color ofARGB(@NotNull Float pA, @NotNull Float pRed, @NotNull Float pGreen, @NotNull Float pBlue) {
        return Color.ofARGB((int)(pA.floatValue() * 255.0f + 0.5f), (int)((double)(pRed.floatValue() * 255.0f) + 0.5), (int)(pGreen.floatValue() * 255.0f + 0.5f), (int)(pBlue.floatValue() * 255.0f + 0.5f));
    }

    @NotNull
    public static Color ofARGB(@NotNull Integer pA, @NotNull Integer pRed, @NotNull Integer pGreen, @NotNull Integer pBlue) {
        return new Color((pA & 0xFF) << 24 | (pRed & 0xFF) << 16 | (pGreen & 0xFF) << 8 | pBlue & 0xFF);
    }

    @NotNull
    public static Color ofHSB(@NotNull Float pHue, @NotNull Float pSaturation, @NotNull Float pBrightness) {
        return Color.ofOpaque(Color.HSBtoARGB(pHue, pSaturation, pBrightness));
    }

    @NotNull
    public static Integer HSBtoARGB(@NotNull Float pHue, @NotNull Float pSaturation, @NotNull Float pBrightness) {
        int pRed = 0;
        int pGreen = 0;
        int pBlue = 0;
        if (pSaturation.floatValue() == 0.0f) {
            pGreen = pBlue = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
            pRed = pBlue;
        } else {
            float h = (pHue.floatValue() - (float)Math.floor(pHue.floatValue())) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = pBrightness.floatValue() * (1.0f - pSaturation.floatValue());
            float q = pBrightness.floatValue() * (1.0f - pSaturation.floatValue() * f);
            float t = pBrightness.floatValue() * (1.0f - pSaturation.floatValue() * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    pRed = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    pGreen = (int)(t * 255.0f + 0.5f);
                    pBlue = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    pRed = (int)(q * 255.0f + 0.5f);
                    pGreen = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    pBlue = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    pRed = (int)(p * 255.0f + 0.5f);
                    pGreen = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    pBlue = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    pRed = (int)(p * 255.0f + 0.5f);
                    pGreen = (int)(q * 255.0f + 0.5f);
                    pBlue = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    pRed = (int)(t * 255.0f + 0.5f);
                    pGreen = (int)(p * 255.0f + 0.5f);
                    pBlue = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    pRed = (int)(pBrightness.floatValue() * 255.0f + 0.5f);
                    pGreen = (int)(p * 255.0f + 0.5f);
                    pBlue = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | pRed << 16 | pGreen << 8 | pBlue;
    }

    @NotNull
    public Integer getColor() {
        return this.argbInt;
    }

    @NotNull
    public Integer getAlpha() {
        return this.argbInt >> 24 & 0xFF;
    }

    @NotNull
    public Float getAlphaFloat() {
        return Float.valueOf((float)this.getAlpha().intValue() / 255.0f);
    }

    @NotNull
    public Integer getRed() {
        return this.argbInt >> 16 & 0xFF;
    }

    @NotNull
    public Float getRedFloat() {
        return Float.valueOf((float)this.getRed().intValue() / 255.0f);
    }

    @NotNull
    public Integer getGreen() {
        return this.argbInt >> 8 & 0xFF;
    }

    @NotNull
    public Float getGreenFloat() {
        return Float.valueOf((float)this.getGreen().intValue() / 255.0f);
    }

    @NotNull
    public Integer getBlue() {
        return this.argbInt & 0xFF;
    }

    @NotNull
    public Float getBlueFloat() {
        return Float.valueOf((float)this.getBlue().intValue() / 255.0f);
    }

    @NotNull
    public Color brighter(@NotNull Double pFactor) {
        int pRed = this.getRed();
        int pGreen = this.getGreen();
        int pBlue = this.getBlue();
        int i = (int)(1.0 / (1.0 - 1.0 / pFactor));
        if (pRed == 0 && pGreen == 0 && pBlue == 0) {
            return Color.ofRGBA(i, i, i, this.getAlpha());
        }
        if (pRed > 0 && pRed < i) {
            pRed = i;
        }
        if (pGreen > 0 && pGreen < i) {
            pGreen = i;
        }
        if (pBlue > 0 && pBlue < i) {
            pBlue = i;
        }
        return Color.ofRGBA(Math.min((int)((double)pRed / (1.0 / pFactor)), 255), Math.min((int)((double)pGreen / (1.0 / pFactor)), 255), Math.min((int)((double)pBlue / (1.0 / pFactor)), 255), this.getAlpha());
    }

    public Color darker(@NotNull Float pFactor) {
        return Color.ofRGBA(Math.max((int)((float)this.getRed().intValue() * (1.0f / pFactor.floatValue())), 0), Math.max((int)((float)this.getGreen().intValue() * (1.0f / pFactor.floatValue())), 0), Math.max((int)((float)this.getBlue().intValue() * (1.0f / pFactor.floatValue())), 0), this.getAlpha());
    }

    @Override
    public boolean equals(@NotNull Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (this.getClass() != pOther.getClass()) {
            return false;
        }
        return this.hashCode() == pOther.hashCode();
    }

    @Override
    public int hashCode() {
        return this.argbInt;
    }

    @Override
    @NotNull
    public String toString() {
        return String.valueOf(this.argbInt);
    }
}

