/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonUtils {
    private JsonUtils() {
    }

    @NotNull
    public static List<Float> jsonArrayToFloatList(@Nullable JsonArray pArray) throws JsonParseException {
        if (pArray == null) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> output = new ArrayList<Float>(pArray.size());
        for (int i = 0; i < pArray.size(); ++i) {
            output.add(Float.valueOf(pArray.get(i).getAsFloat()));
        }
        return output;
    }

    @NotNull
    public static List<Double> jsonArrayToDoubleList(@Nullable JsonArray pArray) throws JsonParseException {
        if (pArray == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> output = new ArrayList<Double>(pArray.size());
        for (int i = 0; i < pArray.size(); ++i) {
            output.add(pArray.get(i).getAsDouble());
        }
        return output;
    }

    @NotNull
    public static List<Integer> jsonArrayToIntList(@Nullable JsonArray pArray) throws JsonParseException {
        if (pArray == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> output = new ArrayList<Integer>(pArray.size());
        for (int i = 0; i < pArray.size(); ++i) {
            output.add(pArray.get(i).getAsInt());
        }
        return output;
    }

    @NotNull
    public static <T> List<T> jsonArrayToObjectList(@Nullable JsonArray pArray, @NotNull JsonDeserializationContext pContext, @NotNull Class<T> pObjectClass) {
        if (pArray == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(pArray.size());
        for (int i = 0; i < pArray.size(); ++i) {
            list.add(pContext.deserialize(pArray.get(i), pObjectClass));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> jsonArrayToList(@Nullable JsonArray pArray, @NotNull Function<JsonElement, T> pElementTransformer) {
        if (pArray == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(pArray.size());
        for (JsonElement element : pArray) {
            list.add(pElementTransformer.apply(element));
        }
        return list;
    }

    @NotNull
    public static List<String> jsonArrayToStringList(@Nullable JsonArray pArray) throws JsonParseException {
        if (pArray == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> output = new ArrayList<String>(pArray.size());
        for (int i = 0; i < pArray.size(); ++i) {
            output.add(pArray.get(i).getAsString());
        }
        return output;
    }

    @NotNull
    public static <T> Map<String, T> jsonObjToMap(@NotNull JsonObject pObj, @NotNull JsonDeserializationContext pContext, @NotNull Class<T> pObjectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(pObj.size());
        for (Map.Entry entry : pObj.entrySet()) {
            map.put((String)entry.getKey(), pContext.deserialize((JsonElement)entry.getValue(), pObjectType));
        }
        return map;
    }

    @NotNull
    public static <T> Map<String, List<T>> jsonObjToListMap(@NotNull JsonObject pObj, @NotNull JsonDeserializationContext pContext, @NotNull Class<T> pObjectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(pObj.size());
        for (Map.Entry entry : pObj.entrySet()) {
            JsonArray arr = ((JsonElement)entry.getValue()).getAsJsonArray();
            List<T> list = JsonUtils.jsonArrayToObjectList(arr, pContext, pObjectType);
            map.put((String)entry.getKey(), list);
        }
        return map;
    }

    @NotNull
    public static JsonObject filterJsonObject(@NotNull JsonObject pSource, String ... pAvoid) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : pSource.entrySet()) {
            String key = (String)entry.getKey();
            boolean skip = false;
            for (String avoid : pAvoid) {
                if (!key.equals(avoid)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            result.add(key, (JsonElement)entry.getValue());
        }
        return result;
    }

    @NotNull
    public static <T> JsonDeserializer<T> unionDeserializer(@NotNull BiFunction<JsonArray, JsonDeserializationContext, T> pArrayMapper, @NotNull BiFunction<JsonObject, JsonDeserializationContext, T> objectMapper) {
        return (json, type, context) -> {
            if (json.isJsonArray()) {
                return pArrayMapper.apply(json.getAsJsonArray(), context);
            }
            if (json.isJsonObject()) {
                return objectMapper.apply(json.getAsJsonObject(), context);
            }
            throw new JsonParseException("Expected JSON array or object but got: " + String.valueOf(json));
        };
    }

    @Nullable
    public static Long getOptionalLong(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? Long.valueOf(GsonHelper.getAsLong((JsonObject)pObj, (String)pElementName)) : null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)pObj, (String)pElementName)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? Float.valueOf(GsonHelper.getAsFloat((JsonObject)pObj, (String)pElementName)) : null;
    }

    @Nullable
    public static Double getOptionalDouble(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? Double.valueOf(GsonHelper.getAsDouble((JsonObject)pObj, (String)pElementName)) : null;
    }

    @Nullable
    public static Integer getOptionalInteger(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? Integer.valueOf(GsonHelper.getAsInt((JsonObject)pObj, (String)pElementName)) : null;
    }

    @Nullable
    public static String getOptionalString(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? GsonHelper.getAsString((JsonObject)pObj, (String)pElementName) : null;
    }

    @Nullable
    public static <T> T getOptionalObject(@NotNull JsonObject pObj, @NotNull String pElementName, @NotNull JsonDeserializationContext pContext, @NotNull Class<T> pType) {
        return (T)(pObj.has(pElementName) ? GsonHelper.getAsObject((JsonObject)pObj, (String)pElementName, (JsonDeserializationContext)pContext, pType) : null);
    }

    @Nullable
    public static JsonArray getOptionalJsonArray(@NotNull JsonObject pObj, @NotNull String pElementName) {
        return pObj.has(pElementName) ? GsonHelper.getAsJsonArray((JsonObject)pObj, (String)pElementName) : null;
    }
}

