/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.gui.version;

import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class VersionWarningScreen
extends Screen {
    private final String modId;
    private final String version;
    private final GridLayout layout = new GridLayout().columnSpacing(10).rowSpacing(20);
    private final OptionInstance<Boolean> dontShowAgain = OptionInstance.createBoolean((String)"bluelib$snapshots$dont_show_again", (boolean)false);
    private final Consumer consumer;

    public VersionWarningScreen(String pModId, String pVersion, Consumer pConsumer) {
        super(VersionWarningScreen.getTranslatableOrFallback(pModId, "version.warning.title", pModId));
        this.modId = pModId;
        this.version = pVersion;
        this.consumer = pConsumer;
    }

    protected void init() {
        super.init();
        GridLayout.RowHelper helper = this.layout.createRowHelper(2);
        LayoutSettings settings = helper.newCellSettings().alignHorizontallyCenter();
        Component title = VersionWarningScreen.getTranslatableOrFallback(this.modId, "version.warning.title", this.modId);
        Component description = VersionWarningScreen.getTranslatableOrFallback(this.modId, "version.warning.description", this.version, this.modId);
        Component dontShowAgainTip = VersionWarningScreen.getTranslatableOrFallback(this.modId, "version.warning.dont_show_again_tip", this.modId);
        helper.addChild((LayoutElement)new StringWidget(title, this.font), 2, settings);
        helper.addChild((LayoutElement)new MultiLineTextWidget(description, this.font).setCentered(true).setMaxWidth(310), 2, settings);
        Checkbox dontShowAgainCheckbox = Checkbox.builder((Component)VersionWarningScreen.getTranslatableOrFallback(this.modId, "version.warning.dont_show_again", this.modId), (Font)Minecraft.getInstance().font).selected(((Boolean)this.dontShowAgain.get()).booleanValue()).tooltip(Tooltip.create((Component)dontShowAgainTip)).build();
        helper.addChild((LayoutElement)dontShowAgainCheckbox, 2, settings);
        helper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_YES, btn -> this.consumer.accept(Acknowledgement.YES, dontShowAgainCheckbox.selected())).build());
        helper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_NO, btn -> this.consumer.accept(Acknowledgement.NO, false)).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
        this.repositionElements();
    }

    protected void repositionElements() {
        FrameLayout.alignInRectangle((LayoutElement)this.layout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.5f);
    }

    public void onClose() {
        this.consumer.accept(Acknowledgement.NO, false);
    }

    private static Component getTranslatableOrFallback(String pModId, String pKey, Object ... pArgs) {
        String fullKey = pModId + "." + pKey;
        MutableComponent comp = Component.translatable((String)fullKey, (Object[])pArgs);
        if (comp.getString().equals(fullKey)) {
            String fallbackKey = "bluelib." + pKey;
            return Component.translatable((String)fallbackKey, (Object[])pArgs);
        }
        return comp;
    }

    public static interface Consumer {
        public void accept(Acknowledgement var1, boolean var2);
    }

    public static enum Acknowledgement {
        YES,
        NO;

    }
}

