/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.net.loader;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.ClientNetworkPacketHandler;
import software.bluelib.client.utils.LevelUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.entity.BlueEntity;
import software.bluelib.loader.animatable.entity.BlueReplacedEntity;
import software.bluelib.net.messages.client.loader.EntityDataSyncPacket;

public class EntityDataSyncPacketHandler<D>
implements ClientNetworkPacketHandler<EntityDataSyncPacket<D>> {
    @Override
    public void handle(@NotNull EntityDataSyncPacket<D> pPacket, @NotNull Minecraft pClient) {
        if (LevelUtils.getLevel() == null) {
            return;
        }
        Entity entity = LevelUtils.getLevel().getEntity(pPacket.entityId().intValue());
        if (entity == null) {
            return;
        }
        if (!pPacket.isReplacedEntity()) {
            if (entity instanceof BlueEntity) {
                BlueEntity BlueEntity2 = (BlueEntity)entity;
                BlueEntity2.setAnimData(pPacket.dataTicket(), pPacket.data());
            }
            return;
        }
        BlueAnimatable blueAnimatable = RenderUtils.getReplacedAnimatable(entity.getType());
        if (blueAnimatable instanceof BlueReplacedEntity) {
            BlueReplacedEntity replacedEntity = (BlueReplacedEntity)blueAnimatable;
            replacedEntity.setAnimData(entity, pPacket.dataTicket(), pPacket.data());
        }
    }
}

