/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.net.loader;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.ClientNetworkPacketHandler;
import software.bluelib.client.utils.LevelUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.entity.BlueEntity;
import software.bluelib.loader.animatable.entity.BlueReplacedEntity;
import software.bluelib.net.messages.client.loader.StopTriggeredEntityAnimPacket;

public class StopTriggeredEntityAnimPacketHandler
implements ClientNetworkPacketHandler<StopTriggeredEntityAnimPacket> {
    @Override
    public void handle(@NotNull StopTriggeredEntityAnimPacket pPacket, @NotNull Minecraft pClient) {
        String animName;
        if (LevelUtils.getLevel() == null) {
            return;
        }
        Entity entity = LevelUtils.getLevel().getEntity(pPacket.entityId().intValue());
        if (entity == null) {
            return;
        }
        String controllerName = pPacket.controllerName().isEmpty() ? null : pPacket.controllerName();
        String string = animName = pPacket.animName().isEmpty() ? null : pPacket.animName();
        if (!pPacket.isReplacedEntity()) {
            if (entity instanceof BlueEntity) {
                BlueEntity BlueEntity2 = (BlueEntity)entity;
                BlueEntity2.stopTriggeredAnim(controllerName, animName);
            }
            return;
        }
        BlueAnimatable blueAnimatable = RenderUtils.getReplacedAnimatable(entity.getType());
        if (blueAnimatable instanceof BlueReplacedEntity) {
            BlueReplacedEntity replacedEntity = (BlueReplacedEntity)blueAnimatable;
            replacedEntity.stopTriggeredAnim(entity, controllerName, animName);
        }
    }
}

