/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.utils;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.Color;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.ResourceUtils;
import software.bluelib.client.utils.TextureUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.CubeCache;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.client.BlueRenderProvider;
import software.bluelib.loader.renderer.entity.BlueReplacedEntityRenderer;

public final class RenderUtils {
    public static void translateMatrixToBone(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.translate(-pBone.getPosX() / 16.0f, pBone.getPosY() / 16.0f, pBone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        if (pBone.getRotZ() != 0.0f) {
            pPoseStack.mulPose(Axis.ZP.rotation(pBone.getRotZ()));
        }
        if (pBone.getRotY() != 0.0f) {
            pPoseStack.mulPose(Axis.YP.rotation(pBone.getRotY()));
        }
        if (pBone.getRotX() != 0.0f) {
            pPoseStack.mulPose(Axis.XP.rotation(pBone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(@NotNull PoseStack pPoseStack, @NotNull CubeCache pCube) {
        Vec3 rotation = pCube.rotation();
        pPoseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.z()));
        pPoseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)rotation.y(), 0.0f));
        pPoseStack.mulPose(new Quaternionf().rotationXYZ((float)rotation.x(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.scale(pBone.getScaleX().floatValue(), pBone.getScaleY().floatValue(), pBone.getScaleZ().floatValue());
    }

    public static void translateToPivotPoint(@NotNull PoseStack pPoseStack, @NotNull CubeCache pCube) {
        Vec3 pivot = pCube.pivot();
        pPoseStack.translate(pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateToPivotPoint(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.translate(pBone.getPivotX() / 16.0f, pBone.getPivotY() / 16.0f, pBone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(@NotNull PoseStack pPoseStack, @NotNull CubeCache pCube) {
        Vec3 pivot = pCube.pivot();
        pPoseStack.translate(-pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPoint(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.translate(-pBone.getPivotX() / 16.0f, -pBone.getPivotY() / 16.0f, -pBone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        RenderUtils.translateToPivotPoint(pPoseStack, pBone);
        RenderUtils.rotateMatrixAroundBone(pPoseStack, pBone);
    }

    public static void prepMatrixForBone(@NotNull PoseStack pPoseStack, @NotNull BoneCache pBone) {
        RenderUtils.translateMatrixToBone(pPoseStack, pBone);
        RenderUtils.translateToPivotPoint(pPoseStack, pBone);
        RenderUtils.rotateMatrixAroundBone(pPoseStack, pBone);
        RenderUtils.scaleMatrixForBone(pPoseStack, pBone);
        RenderUtils.translateAwayFromPivotPoint(pPoseStack, pBone);
    }

    public static Matrix4f invertAndMultiplyMatrices(@NotNull Matrix4f pBaseMatrix, @NotNull Matrix4f pInputMatrix) {
        pInputMatrix = new Matrix4f((Matrix4fc)pInputMatrix);
        pInputMatrix.invert();
        pInputMatrix.mul((Matrix4fc)pBaseMatrix);
        return pInputMatrix;
    }

    public static void faceRotation(@NotNull PoseStack pPoseStack, @NotNull Entity pAnimatable, @NotNull Float pPartialTick) {
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick.floatValue(), (float)pAnimatable.yRotO, (float)pAnimatable.getYRot()) - 90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTick.floatValue(), (float)pAnimatable.xRotO, (float)pAnimatable.getXRot())));
    }

    public static Matrix4f translateMatrix(@NotNull Matrix4f pMatrix, @NotNull Vector3f pVector) {
        return pMatrix.add((Matrix4fc)new Matrix4f().m30(pVector.x).m31(pVector.y).m32(pVector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(@NotNull ResourceLocation pTexture) {
        AbstractTexture originalTexture = null;
        try {
            originalTexture = (AbstractTexture)Minecraft.getInstance().submit(() -> TextureUtils.getTexture(pTexture)).get();
        }
        catch (Exception pException) {
            BaseLogger.log(BaseLogLevel.ERROR, "Failed to get texture dimensions for: " + String.valueOf(pTexture), pException);
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.getPixels();
            } else {
                nativeImage = ResourceUtils.getResource(pTexture).map(resource -> {
                    try {
                        return NativeImage.read((InputStream)resource.open());
                    }
                    catch (Exception e) {
                        BaseLogger.log(BaseLogLevel.ERROR, "Failed to read texture image for: " + String.valueOf(pTexture), e);
                        return null;
                    }
                }).orElse(null);
            }
            image = nativeImage;
        }
        catch (Exception pException) {
            BaseLogger.log(BaseLogLevel.ERROR, "Failed to read texture image for: " + String.valueOf(pTexture), pException);
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.getWidth(), (int)image.getHeight());
    }

    @NotNull
    public static Double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    @NotNull
    public static Double getCurrentTick() {
        return Blaze3D.getTime() * 20.0;
    }

    @NotNull
    public static Float booleanToFloat(boolean pInput) {
        return Float.valueOf(pInput ? 1.0f : 0.0f);
    }

    @NotNull
    public static Vec3 listToVec(@NotNull List<Float> pArray) {
        if (pArray.size() < 3) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return new Vec3((double)pArray.get(0).floatValue(), (double)pArray.get(1).floatValue(), (double)pArray.get(2).floatValue());
    }

    public static void matchModelPartRot(@NotNull ModelPart pModelPart, @NotNull BoneCache pBone) {
        pBone.updateRotation(-pModelPart.xRot, -pModelPart.yRot, pModelPart.zRot);
    }

    public static void fixInvertedFlatCube(@NotNull CubeCache pCube, @NotNull Vector3f pNormal) {
        if (pNormal.x() < 0.0f && (pCube.size().y() == 0.0 || pCube.size().z() == 0.0)) {
            pNormal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (pNormal.y() < 0.0f && (pCube.size().x() == 0.0 || pCube.size().z() == 0.0)) {
            pNormal.mul(1.0f, -1.0f, 1.0f);
        }
        if (pNormal.z() < 0.0f && (pCube.size().x() == 0.0 || pCube.size().y() == 0.0)) {
            pNormal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    @NotNull
    public static Float getDirectionAngle(@NotNull Direction pDirection) {
        return switch (pDirection) {
            case Direction.SOUTH -> Float.valueOf(90.0f);
            case Direction.NORTH -> Float.valueOf(270.0f);
            case Direction.EAST -> Float.valueOf(180.0f);
            default -> Float.valueOf(0.0f);
        };
    }

    @NotNull
    public static Double lerpYaw(@NotNull Double pDelta, @NotNull Double pStart, @NotNull Double pEnd) {
        pStart = Mth.wrapDegrees((double)pStart);
        pEnd = Mth.wrapDegrees((double)pEnd);
        double diff = pStart - pEnd;
        pEnd = diff > 180.0 || diff < -180.0 ? pStart + Math.copySign(360.0 - Math.abs(diff), diff) : pEnd;
        return Mth.lerp((double)pDelta, (double)pStart, (double)pEnd);
    }

    @Nullable
    public static BlueModel<?> getBlueModelForEntityType(@NotNull EntityType<?> pEntityType) {
        BlueModel blueModel;
        EntityRenderer renderer = (EntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(pEntityType);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueAnimatable getReplacedAnimatable(@NotNull EntityType<?> pEntityType) {
        BlueAnimatable blueAnimatable;
        EntityRenderer renderer = (EntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(pEntityType);
        if (renderer instanceof BlueReplacedEntityRenderer) {
            BlueReplacedEntityRenderer replacedEntityRenderer = (BlueReplacedEntityRenderer)renderer;
            blueAnimatable = (BlueAnimatable)replacedEntityRenderer.getOptionalAnimatable();
        } else {
            blueAnimatable = null;
        }
        return blueAnimatable;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForEntity(@NotNull Entity pEntity) {
        BlueModel blueModel;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(pEntity);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForItem(@NotNull ItemStack pItem) {
        return BlueLibConstants.PlatformHelper.ITEM_RENDERING.getBlueModelForItem(pItem);
    }

    @Nullable
    public static BlueModel<?> getBlueModelForBlock(@NotNull BlockEntity pBlockEntity) {
        BlueModel blueModel;
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(pBlockEntity);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForArmor(@NotNull ItemStack pStack) {
        return BlueLibConstants.PlatformHelper.ITEM_RENDERING.getBlueModelForArmor(pStack);
    }

    @NotNull
    public static <T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> Boolean tryRenderArmorPiece(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, @NotNull T pEntity, @NotNull ItemStack pStack, @NotNull EquipmentSlot pEquipmentSlot, @NotNull M pParentModel, @NotNull A pBaseModel, @NotNull Float pPartialTick, @NotNull Integer pPackedLight, @NotNull Float pLimbSwing, @NotNull Float pLimbSwingAmount, @NotNull Float pLerpedTickCount, @NotNull Float pNetHeadYaw, @NotNull Float pHeadPitch, @NotNull BiConsumer<A, EquipmentSlot> pPartVisibilitySetter) {
        Equipable equipable;
        Item item = pStack.getItem();
        if (!(item instanceof Equipable) || (equipable = (Equipable)item).getEquipmentSlot() != pEquipmentSlot) {
            return false;
        }
        HumanoidModel<?> model = BlueRenderProvider.of(item).getBlueArmorRenderer(pEntity, pStack, pEquipmentSlot, pBaseModel);
        if (model == null) {
            return false;
        }
        pParentModel.copyPropertiesTo(pBaseModel);
        pPartVisibilitySetter.accept(pBaseModel, pEquipmentSlot);
        pBaseModel.copyPropertiesTo(model);
        model.renderToBuffer(pPoseStack, null, pPackedLight.intValue(), OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
        return true;
    }
}

