/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.config.bluelib;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.config.ConfigBuilder;

public class MarkdownConfig {
    @NotNull
    public final ModConfigSpec.BooleanValue isMarkdownEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> boldPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> boldSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isBoldEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> italicPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> italicSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isItalicEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> underlinePrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> underlineSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isUnderlineEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> strikethroughPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> strikethroughSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isStrikethroughEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> spoilerPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> spoilerSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isSpoilerEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> hyperlinkPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> hyperlinkSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isHyperlinkEnabled;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> colorPrefix;
    @NotNull
    public final ModConfigSpec.ConfigValue<String> colorSuffix;
    @NotNull
    public final ModConfigSpec.BooleanValue isColorEnabled;
    @NotNull
    public final ModConfigSpec.BooleanValue isCopyToClipboardEnabled;

    public MarkdownConfig(@NotNull ModConfigSpec.Builder pBuilder) {
        pBuilder.push("Markdown");
        this.isMarkdownEnabled = ConfigBuilder.buildBoolean(pBuilder, "markdownEnabled", true, "Default is 'true/on'");
        pBuilder.push("Bold");
        this.boldPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "**", "Default is '**'");
        this.boldSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "**", "Default is '**'");
        this.isBoldEnabled = ConfigBuilder.buildBoolean(pBuilder, "boldEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Italic");
        this.italicPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "*", "Default is '*'");
        this.italicSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "*", "Default is '*'");
        this.isItalicEnabled = ConfigBuilder.buildBoolean(pBuilder, "italicEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Underline");
        this.underlinePrefix = ConfigBuilder.buildString(pBuilder, "prefix", "__", "Default is '__'");
        this.underlineSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "__", "Default is '__'");
        this.isUnderlineEnabled = ConfigBuilder.buildBoolean(pBuilder, "underlineEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Strikethrough");
        this.strikethroughPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "~~", "Default is '~~'");
        this.strikethroughSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "~~", "Default is '~~'");
        this.isStrikethroughEnabled = ConfigBuilder.buildBoolean(pBuilder, "strikethroughEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Spoiler");
        this.spoilerPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "||", "Default is '||'");
        this.spoilerSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "||", "Default is '||'");
        this.isSpoilerEnabled = ConfigBuilder.buildBoolean(pBuilder, "spoilerEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Hyperlink");
        this.hyperlinkPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "[", "Default is '['");
        this.hyperlinkSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "]", "Default is ']'");
        this.isHyperlinkEnabled = ConfigBuilder.buildBoolean(pBuilder, "hyperlinkEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("Color");
        this.colorPrefix = ConfigBuilder.buildString(pBuilder, "prefix", "-", "Default is '-'");
        this.colorSuffix = ConfigBuilder.buildString(pBuilder, "suffix", "-", "Default is '-'");
        this.isColorEnabled = ConfigBuilder.buildBoolean(pBuilder, "colorEnabled", true, "Default is 'true/on'");
        pBuilder.pop(1);
        pBuilder.push("CopyToClipboard");
        this.isCopyToClipboardEnabled = ConfigBuilder.buildBoolean(pBuilder, "copyToClipboardEnabled", true, "Default is 'true/on'");
        pBuilder.pop(2);
    }
}

