/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.loader.cache.ResourceCache;

public class ReloadHandler {
    @NotNull
    protected static final List<IVariantProvider> providers = new ArrayList<IVariantProvider>();

    public static void registerProvider(@NotNull IVariantProvider pProvider) {
        providers.add(pProvider);
    }

    public static void onServerStart(@NotNull MinecraftServer pServer) {
        BlueLibConstants.SCHEDULER = new ScheduledThreadPoolExecutor(1);
        BlueLibConstants.server = pServer;
        if (providers.isEmpty()) {
            return;
        }
        ResourceCache.Server.registerReloadListener(pServer, providers);
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("variants.loaded"));
    }

    public static void onReload(@NotNull MinecraftServer pServer) {
        if (providers.isEmpty()) {
            return;
        }
        ResourceCache.Server.registerReloadListener(pServer, providers);
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("variants.reloaded"));
    }
}

