/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.base;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.bone.BoneSnapshot;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.controller.ControllerManager;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;

public class AnimatableManager<T extends BlueAnimatable> {
    @NotNull
    private final Map<String, BoneSnapshot> boneSnapshotCollection = new Object2ObjectOpenHashMap();
    @NotNull
    private final Map<String, AnimationController<T>> animationControllers;
    @Nullable
    private Map<DataTicket<?>, Object> extraData;
    private double lastUpdateTime;
    private boolean isFirstTick = true;
    private double firstTickTime = -1.0;

    public AnimatableManager(@NotNull BlueAnimatable pAnimatable) {
        ControllerRegistrar registrar = new ControllerRegistrar(new ObjectArrayList(2));
        ControllerCache controllerCache = ControllerManager.getBakedController(pAnimatable.getControllerResource());
        new ControllerManager().registerControllers(pAnimatable, controllerCache, registrar);
        pAnimatable.registerControllers(registrar);
        this.animationControllers = registrar.build();
    }

    public void addController(@NotNull AnimationController<T> pController) {
        this.getAnimationControllers().put(pController.getName(), pController);
    }

    public void removeController(@NotNull String pName) {
        this.getAnimationControllers().remove(pName);
    }

    @NotNull
    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.animationControllers;
    }

    @NotNull
    public Map<String, BoneSnapshot> getBoneSnapshotCollection() {
        return this.boneSnapshotCollection;
    }

    public void clearSnapshotCache() {
        this.getBoneSnapshotCollection().clear();
    }

    @NotNull
    public Double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updatedAt(@NotNull Double pUpdateTime) {
        this.lastUpdateTime = pUpdateTime;
    }

    @NotNull
    public Double getFirstTickTime() {
        return this.firstTickTime;
    }

    public void startedAt(@NotNull Double pTime) {
        this.firstTickTime = pTime;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    public void finishFirstTick() {
        this.isFirstTick = false;
    }

    public <D> void setData(@NotNull DataTicket<D> pDataTicket, @NotNull D pData) {
        if (this.extraData == null) {
            this.extraData = new Object2ObjectOpenHashMap();
        }
        this.extraData.put(pDataTicket, pData);
    }

    @Nullable
    public <D> D getData(@NotNull DataTicket<D> pDataTicket) {
        return this.extraData != null ? (D)pDataTicket.getData(this.extraData) : null;
    }

    public void tryTriggerAnimation(@NotNull String pAnimName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (!controller.tryTriggerAnimation(pAnimName)) continue;
            return;
        }
    }

    public void tryTriggerAnimation(@NotNull String pControllerName, @NotNull String pAnimName) {
        AnimationController<T> controller = this.getAnimationControllers().get(pControllerName);
        if (controller != null) {
            controller.tryTriggerAnimation(pAnimName);
        }
    }

    public void stopTriggeredAnimation(@Nullable String pAnimName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (pAnimName != null && controller.triggerableAnimations.get(pAnimName) != controller.getTriggeredAnimation() || !controller.stopTriggeredAnimation()) continue;
            return;
        }
    }

    public void stopTriggeredAnimation(@Nullable String pControllerName, @Nullable String pAnimName) {
        AnimationController<T> controller = this.getAnimationControllers().get(pControllerName);
        if (controller != null && (pAnimName == null || controller.triggerableAnimations.get(pAnimName) == controller.getTriggeredAnimation())) {
            controller.stopTriggeredAnimation();
        }
    }

    public record ControllerRegistrar<T extends BlueAnimatable>(@NotNull List<AnimationController<T>> controllers) {
        @SafeVarargs
        @NotNull
        public final ControllerRegistrar<T> add(AnimationController<T> ... pControllers) {
            this.controllers().addAll(Arrays.asList(pControllers));
            return this;
        }

        @NotNull
        public ControllerRegistrar<T> add(@NotNull AnimationController<T> pController) {
            this.controllers().add(pController);
            return this;
        }

        @NotNull
        public ControllerRegistrar<T> remove(@NotNull String pName) {
            this.controllers().removeIf(controller -> controller.getName().equals(pName));
            return this;
        }

        @ApiStatus.Internal
        @NotNull
        private Object2ObjectArrayMap<String, AnimationController<T>> build() {
            Object2ObjectArrayMap map = new Object2ObjectArrayMap(this.controllers().size());
            this.controllers().forEach(controller -> map.put((Object)controller.getName(), controller));
            return map;
        }
    }
}

