/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.geckolib.math.function;

import java.util.StringJoiner;
import software.bluelib.loader.geckolib.math.MathValue;

public abstract class MathFunction
implements MathValue {
    private final boolean isMutable;
    private double cachedValue = Double.MIN_VALUE;

    protected MathFunction(MathValue ... values) {
        this.validate(values);
        this.isMutable = this.isMutable(values);
    }

    public abstract String getName();

    @Override
    public final double get() {
        if (this.isMutable) {
            return this.compute();
        }
        if (this.cachedValue == Double.MIN_VALUE) {
            this.cachedValue = this.compute();
        }
        return this.cachedValue;
    }

    public abstract double compute();

    public boolean isMutable(MathValue ... values) {
        for (MathValue value : values) {
            if (!value.isMutable()) continue;
            return true;
        }
        return false;
    }

    public abstract int getMinArgs();

    public abstract MathValue[] getArgs();

    public void validate(MathValue ... inputs) throws IllegalArgumentException {
        int minArgs = this.getMinArgs();
        if (inputs.length < minArgs) {
            throw new IllegalArgumentException(String.format("Function '%s' at least %s arguments. Only %s given!", this.getName(), minArgs, inputs.length));
        }
    }

    @Override
    public final boolean isMutable() {
        return this.isMutable;
    }

    public String toString() {
        MathValue[] args = this.getArgs();
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (MathValue arg : args) {
            joiner.add(arg.toString());
        }
        return this.getName() + String.valueOf(joiner);
    }

    @FunctionalInterface
    public static interface Factory<T extends MathFunction> {
        public T create(MathValue ... var1);
    }
}

