/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.BlueLoader;
import software.bluelib.loader.animation.keyframe.data.CustomInstructionKeyframeData;
import software.bluelib.loader.animation.keyframe.data.ParticleKeyframeData;
import software.bluelib.loader.animation.keyframe.data.SoundKeyframeData;
import software.bluelib.loader.cache.animations.keyframe.KeyframeLibraryCache;

public class KeyFramesAdapter
implements JsonDeserializer<KeyframeLibraryCache> {
    @NotNull
    public KeyframeLibraryCache deserialize(@NotNull JsonElement pJson, @NotNull Type pType, @NotNull JsonDeserializationContext pContext) throws JsonParseException {
        JsonObject obj = pJson.getAsJsonObject();
        SoundKeyframeData[] sounds = KeyFramesAdapter.buildSoundFrameData(obj);
        ParticleKeyframeData[] particles = KeyFramesAdapter.buildParticleFrameData(obj);
        CustomInstructionKeyframeData[] customInstructions = KeyFramesAdapter.buildCustomFrameData(obj);
        return new KeyframeLibraryCache(sounds, particles, customInstructions);
    }

    @NotNull
    private static SoundKeyframeData[] buildSoundFrameData(@NotNull JsonObject pRootObj) {
        JsonObject soundsObj = GsonHelper.getAsJsonObject((JsonObject)pRootObj, (String)"sound_effects", (JsonObject)new JsonObject());
        SoundKeyframeData[] sounds = new SoundKeyframeData[soundsObj.size()];
        int index = 0;
        for (Map.Entry entry : soundsObj.entrySet()) {
            sounds[index] = new SoundKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, GsonHelper.getAsString((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"effect"));
            ++index;
        }
        return sounds;
    }

    @NotNull
    private static ParticleKeyframeData[] buildParticleFrameData(@NotNull JsonObject pRootObj) {
        JsonObject particlesObj = GsonHelper.getAsJsonObject((JsonObject)pRootObj, (String)"particle_effects", (JsonObject)new JsonObject());
        ParticleKeyframeData[] particles = new ParticleKeyframeData[particlesObj.size()];
        int index = 0;
        for (Map.Entry entry : particlesObj.entrySet()) {
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            String effect = GsonHelper.getAsString((JsonObject)obj, (String)"effect", (String)"");
            String locator = GsonHelper.getAsString((JsonObject)obj, (String)"locator", (String)"");
            String script = GsonHelper.getAsString((JsonObject)obj, (String)"pre_effect_script", (String)"");
            particles[index] = new ParticleKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, effect, locator, script);
            ++index;
        }
        return particles;
    }

    @NotNull
    private static CustomInstructionKeyframeData[] buildCustomFrameData(@NotNull JsonObject pRootObj) {
        JsonObject customInstructionsObj = GsonHelper.getAsJsonObject((JsonObject)pRootObj, (String)"timeline", (JsonObject)new JsonObject());
        CustomInstructionKeyframeData[] customInstructions = new CustomInstructionKeyframeData[customInstructionsObj.size()];
        int index = 0;
        for (Map.Entry entry : customInstructionsObj.entrySet()) {
            String instructions = "";
            Object v = entry.getValue();
            if (v instanceof JsonArray) {
                JsonArray array = (JsonArray)v;
                instructions = ((ObjectArrayList)BlueLoader.ANIMATION_GSON.fromJson((JsonElement)array, ObjectArrayList.class)).toString();
            } else {
                v = entry.getValue();
                if (v instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)v;
                    instructions = primitive.getAsString();
                }
            }
            customInstructions[index] = new CustomInstructionKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, instructions);
            ++index;
        }
        return customInstructions;
    }
}

