/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.controller;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;

public record Animation(@NotNull List<String> conditions, @NotNull String animation, @Nullable Integer priority, @Nullable String sound) {
    @NotNull
    public static JsonDeserializer<Animation> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            List<String> conditions = JsonUtils.jsonArrayToStringList(GsonHelper.getAsJsonArray((JsonObject)obj, (String)"conditions"));
            String animation = GsonHelper.getAsString((JsonObject)obj, (String)"animation");
            Integer priority = JsonUtils.getOptionalInteger(obj, "priority");
            String sound = JsonUtils.getOptionalString(obj, "sound");
            return new Animation(conditions, animation, priority, sound);
        };
    }
}

