/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;
import software.bluelib.loader.json.deserialize.model.Bone;
import software.bluelib.loader.json.deserialize.model.ModelDescription;

public record ModelGeometry(@Nullable ModelDescription modelDescription, @NotNull List<Bone> bones, @Nullable String cape) {
    @NotNull
    public static JsonDeserializer<ModelGeometry> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            ModelDescription modelDescription = JsonUtils.getOptionalObject(obj, "description", context, ModelDescription.class);
            List<Bone> bones = JsonUtils.jsonArrayToObjectList(GsonHelper.getAsJsonArray((JsonObject)obj, (String)"bones", (JsonArray)new JsonArray(0)), context, Bone.class);
            String cape = JsonUtils.getOptionalString(obj, "cape");
            return new ModelGeometry(modelDescription, bones, cape);
        };
    }
}

