/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.LoaderUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.entity.BlueReplacedEntity;
import software.bluelib.loader.animation.AnimationProcessor;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.ResourceCache;
import software.bluelib.loader.cache.animations.AnimationCache;
import software.bluelib.loader.cache.animations.AnimationLibraryCache;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.renderer.base.BlueRenderer;

public abstract class BlueModel<T extends BlueAnimatable> {
    @NotNull
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    @Nullable
    private ModelCache currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;
    @Nullable
    private final ResourceLocation basePath;

    protected BlueModel() {
        this.basePath = null;
    }

    protected BlueModel(@Nullable ResourceLocation pBasePath) {
        this.basePath = pBasePath;
    }

    @Nullable
    protected String subtype() {
        return null;
    }

    @NotNull
    public ResourceLocation getModelResource(@NotNull T pAnimatable, @Nullable BlueRenderer<T> pRenderer) {
        if (this.basePath == null) {
            throw new IllegalStateException("No basePath specified for model resource.");
        }
        String type = this.subtype();
        if (type == null) {
            return this.basePath;
        }
        return this.basePath.withPath("geo/" + type + "/" + this.basePath.getPath() + ".geo.json");
    }

    @NotNull
    public ResourceLocation getTextureResource(@NotNull T pAnimatable, @Nullable BlueRenderer<T> pRenderer) {
        if (this.basePath == null) {
            throw new IllegalStateException("No basePath specified for texture resource.");
        }
        String type = this.subtype();
        if (type == null) {
            return this.basePath;
        }
        return this.basePath.withPath("textures/" + type + "/" + this.basePath.getPath() + ".png");
    }

    @NotNull
    public ResourceLocation getAnimationResource(@NotNull T pAnimatable) {
        if (this.basePath == null) {
            throw new IllegalStateException("No basePath specified for animation resource.");
        }
        String type = this.subtype();
        if (type == null) {
            return this.basePath;
        }
        return this.basePath.withPath("animations/" + type + "/" + this.basePath.getPath() + ".animation.json");
    }

    @NotNull
    public ResourceLocation[] getAnimationResourceFallbacks(@NotNull T pAnimatable) {
        return new ResourceLocation[0];
    }

    public boolean crashIfBoneMissing() {
        return false;
    }

    @NotNull
    public RenderType getRenderType(@NotNull T pAnimatable, @NotNull ResourceLocation pTexture) {
        return RenderType.entityCutoutNoCull((ResourceLocation)pTexture);
    }

    @NotNull
    public ModelCache getBakedModel(@NotNull ResourceLocation pLocation) {
        ResourceLocation[] attempts;
        for (ResourceLocation loc : attempts = new ResourceLocation[]{pLocation, LoaderUtils.stripSuffix(".json", pLocation), LoaderUtils.stripSuffix(".geo.json", pLocation)}) {
            ModelCache model = ResourceCache.Client.getBakedModels().get(loc);
            if (model == null) continue;
            if (model != this.currentModel) {
                this.processor.setActiveModel(model);
                this.currentModel = model;
            }
            return this.currentModel;
        }
        if (!pLocation.getPath().contains("model/")) {
            throw new RuntimeException("Invalid model resource path provided - BlueLib models must be placed in assets/<modid>/model/");
        }
        throw new RuntimeException("Unable to find model file: " + String.valueOf(pLocation));
    }

    @NotNull
    public Optional<BoneCache> getBone(@NotNull String pName) {
        return Optional.of(this.getAnimationProcessor().getBone(pName));
    }

    @Nullable
    public AnimationCache getAnimation(@NotNull T pAnimatable, @NotNull String pName) {
        AnimationCache animationCache;
        AnimationLibraryCache animationLibraryCache;
        ResourceLocation[] attempts;
        ResourceLocation location = this.getAnimationResource(pAnimatable);
        for (ResourceLocation loc : attempts = new ResourceLocation[]{location, LoaderUtils.stripSuffix(".json", location), LoaderUtils.stripSuffix(".animation.json", location)}) {
            animationLibraryCache = ResourceCache.Client.getBakedAnimations().get(loc);
            AnimationCache animationCache2 = animationCache = animationLibraryCache != null ? animationLibraryCache.getAnimation(pName) : null;
            if (animationCache == null) continue;
            return animationCache;
        }
        for (ResourceLocation fallbackLocation : this.getAnimationResourceFallbacks(pAnimatable)) {
            animationLibraryCache = ResourceCache.Client.getBakedAnimations().get(fallbackLocation);
            AnimationCache animationCache3 = animationCache = animationLibraryCache != null ? animationLibraryCache.getAnimation(pName) : null;
            if (animationCache == null) continue;
            return animationCache;
        }
        if (!location.getPath().contains("animation/")) {
            throw new RuntimeException("Invalid animation resource path provided - BlueLib animations must be placed in assets/<modid>/animations/");
        }
        throw new RuntimeException("Unable to find animation file: " + String.valueOf(location));
    }

    @NotNull
    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(@NotNull T pAnimatable, long pInstanceId, @NotNull BiConsumer<DataTicket<T>, T> pDataConsumer) {
    }

    @ApiStatus.Internal
    public void handleAnimations(@NotNull T pAnimatable, long pInstanceId, @NotNull AnimationState<T> pAnimationState, float pPartialTick) {
        boolean pIsReRender;
        Minecraft mc = Minecraft.getInstance();
        AnimatableManager animatableManager = pAnimatable.getAnimatableInstanceCache().getManagerForId(pInstanceId);
        Double currentTick = pAnimationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (pAnimatable instanceof Entity) {
                Entity entity = (Entity)pAnimatable;
                d = entity.tickCount;
            } else {
                d = RenderUtils.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)pPartialTick);
        }
        double currentFrameTime = pAnimatable instanceof Entity || pAnimatable instanceof BlueReplacedEntity ? currentTick + (double)pPartialTick : currentTick - animatableManager.getFirstTickTime();
        boolean bl = pIsReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (pIsReRender && pInstanceId == this.lastRenderedInstance) {
            return;
        }
        if (!mc.isPaused() || pAnimatable.playWhilePaused()) {
            animatableManager.updatedAt(currentFrameTime);
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        pAnimationState.animationTick = this.animTime;
        this.lastRenderedInstance = pInstanceId;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(pAnimationState, this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(pAnimatable, this, animatableManager, this.animTime, pAnimationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(pAnimatable, pInstanceId, pAnimationState);
    }

    public void setCustomAnimations(@NotNull T pAnimatable, long pInstanceId, @NotNull AnimationState<T> pAnimationState) {
    }

    public void applyMolangQueries(@NotNull AnimationState<T> pAnimationState, double pAnimTime) {
        this.animTime = pAnimTime;
    }
}

