/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueBlockRenderer<T extends BlockEntity>
implements BlueRenderer<T>,
BlockEntityRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueBlockRenderer(@NotNull BlueModel<T> pModel) {
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return ((BlockEntity)pContext.animatable()).getBlockPos().hashCode();
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueBlockRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueBlockRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueBlockRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.blockRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        if (!pContext.isReRender()) {
            pContext.poseStack().translate(0.5, 0.0, 0.5);
        }
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void render(@NotNull T pAnimatable, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.animatable = pAnimatable;
        this.defaultRender(new BaseRenderContext<BlockEntity>(pPoseStack, (BlockEntity)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(pAnimatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay((BlockEntity)this.getAnimatable(), 0.0f, pPartialTick), this.getRenderColor((BlockEntity)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            PoseStack pPoseStack = full.poseStack();
            BlockEntity animatable = (BlockEntity)full.animatable();
            VertexConsumer buffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            if (!pIsReRender) {
                AnimationState<BlockEntity> animationState = new AnimationState<BlockEntity>(animatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<BlockEntity> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueAnimatable)animatable).getTick(animatable));
                animationState.setData(DataTickets.BLOCK_ENTITY, animatable);
                currentModel.addAdditionalStateData(animatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                this.rotateBlock(this.getFacing(animatable), pPoseStack);
                currentModel.handleAnimations(animatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.last().pose());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            BlockPos pos = ((BlockEntity)this.getAnimatable()).getBlockPos();
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(localMatrix);
            pBone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.getX(), (float)pos.getY(), (float)pos.getZ())));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    protected void rotateBlock(@NotNull Direction pFacing, @NotNull PoseStack pPoseStack) {
        switch (pFacing) {
            case SOUTH: {
                pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case EAST: {
                pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case UP: {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                pPoseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            }
        }
    }

    @NotNull
    protected Direction getFacing(@NotNull T pBlock) {
        BlockState blockState = pBlock.getBlockState();
        if (blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        }
        if (blockState.hasProperty((Property)DirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((BlockEntity)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileBlockRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireBlockPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireBlockPostRender(this, pContext);
    }
}

