/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.item.BlueItem;

public interface BlueRenderProvider {
    @NotNull
    public static final BlueRenderProvider DEFAULT = new BlueRenderProvider(){};

    @NotNull
    public static BlueRenderProvider of(@NotNull ItemStack pItemStack) {
        return BlueRenderProvider.of(pItemStack.getItem());
    }

    @NotNull
    public static BlueRenderProvider of(@NotNull Item pItem) {
        if (pItem instanceof BlueItem) {
            BlueItem BlueItem2 = (BlueItem)pItem;
            return (BlueRenderProvider)BlueItem2.getRenderProvider();
        }
        return DEFAULT;
    }

    @Nullable
    default public BlockEntityWithoutLevelRenderer getBlueItemRenderer() {
        return null;
    }

    @Nullable
    default public <T extends LivingEntity> HumanoidModel<?> getBlueArmorRenderer(@Nullable T pLivingEntity, @NotNull ItemStack pItemStack, @Nullable EquipmentSlot pEquipmentSlot, @Nullable HumanoidModel<T> pOriginal) {
        return null;
    }
}

