/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.Color;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.data.EntityModelData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.EntityRenderUtils;

public class BlueEntityRenderer<T extends Entity>
extends EntityRenderer<T>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueEntityRenderer(@NotNull EntityRendererProvider.Context pRenderManager, @NotNull BlueModel<T> pModel) {
        super(pRenderManager);
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return ((Entity)pContext.animatable()).getId();
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pAnimatable) {
        return BlueRenderer.super.getTextureLocation(pAnimatable);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueEntityRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueEntityRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueEntityRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    @NotNull
    public Color getRenderColor(@NotNull T pAnimatable, float pPartialTick, int pPackedLight) {
        Color color = BlueRenderer.super.getRenderColor(pAnimatable, pPartialTick, pPackedLight);
        if (pAnimatable.isInvisible() && !pAnimatable.isInvisibleTo(PlayerUtils.getClientPlayer())) {
            color = Color.ofARGB(Mth.ceil((float)((float)(color.getAlpha() * 38) / 255.0f)), color.getRed(), color.getGreen(), color.getBlue());
        }
        return color;
    }

    @Override
    @Nullable
    public RenderType getRenderType(@NotNull ResourceLocation pTexture, @NotNull IRenderContext<T> pContext) {
        boolean invisible = ((Entity)pContext.animatable()).isInvisible();
        if (invisible && !((Entity)pContext.animatable()).isInvisibleTo(PlayerUtils.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)pTexture);
        }
        if (!invisible) {
            return BlueRenderer.super.getRenderType(pTexture, pContext);
        }
        return Minecraft.getInstance().shouldEntityAppearGlowing((Entity)pContext.animatable()) ? RenderType.outline((ResourceLocation)pTexture) : null;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void render(@NotNull T pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight) {
        this.animatable = pEntity;
        this.defaultRender(new BaseRenderContext<T>(pPoseStack, pEntity, this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay(pEntity, 0.0f, pPartialTick), this.getRenderColor(pEntity, pPartialTick, pPackedLight).argbInt()));
        this.animatable = null;
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            float[] fArray;
            LivingEntity e;
            FullRenderContext full = (FullRenderContext)pContext;
            PoseStack poseStack = full.poseStack();
            Entity animatable = (Entity)full.animatable();
            VertexConsumer buffer = full.optionalBuffer();
            boolean isReRender = full.isReRender();
            float partialTick = full.partialTick();
            poseStack.pushPose();
            LivingEntity livingEntity = animatable instanceof LivingEntity ? (e = (LivingEntity)animatable) : null;
            boolean shouldSit = animatable.isPassenger() && animatable.getVehicle() != null;
            float lerpBodyRot = EntityRenderUtils.getLerpBodyRot(livingEntity, partialTick);
            float lerpHeadRot = EntityRenderUtils.getLerpHeadRot(livingEntity, partialTick);
            float[] adjusted = EntityRenderUtils.adjustSittingRotations(shouldSit, animatable, lerpHeadRot, lerpBodyRot, partialTick);
            lerpBodyRot = adjusted[0];
            float netHeadYaw = adjusted[1];
            if (livingEntity != null) {
                EntityRenderUtils.applySleepingTranslation(poseStack, livingEntity);
            }
            float nativeScale = livingEntity != null ? livingEntity.getScale() : 1.0f;
            float ageInTicks = (float)animatable.tickCount + partialTick;
            poseStack.scale(nativeScale, nativeScale, nativeScale);
            this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
            if (livingEntity != null) {
                fArray = EntityRenderUtils.computeLimbSwing(livingEntity, shouldSit, partialTick);
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            }
            float[] limbSwingData = fArray;
            float limbSwing = limbSwingData[0];
            float limbSwingAmount = limbSwingData[1];
            if (!isReRender) {
                float headPitch = Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot());
                float motionThreshold = this.getMotionAnimThreshold(pContext);
                boolean moving = livingEntity != null ? EntityRenderUtils.isEntityMoving(livingEntity, motionThreshold, limbSwingAmount) : Math.abs(limbSwingAmount) >= motionThreshold;
                AnimationState<Entity> state = new AnimationState<Entity>(animatable, limbSwing, limbSwingAmount, partialTick, moving);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<Entity> model = this.getBlueModel();
                state.setData(DataTickets.TICK, ((BlueAnimatable)animatable).getTick(animatable));
                state.setData(DataTickets.ENTITY, animatable);
                state.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.isBaby(), -netHeadYaw, -headPitch));
                model.addAdditionalStateData(animatable, instanceId, (x$0, x$1) -> state.setData(x$0, x$1));
                model.handleAnimations(animatable, instanceId, state, partialTick);
            }
            poseStack.translate(0.0f, 0.01f, 0.0f);
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            poseStack.popPose();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void applyRenderLayers(@NotNull IRenderContext<T> pContext) {
        if (!((Entity)pContext.animatable()).isSpectator()) {
            BlueRenderer.super.applyRenderLayers(pContext);
        }
    }

    @Override
    public void renderFinal(@NotNull IRenderContext<T> pContext) {
        Mob mob;
        Entity leashHolder;
        super.render((Entity)pContext.animatable(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        T t = this.animatable;
        if (t instanceof Mob && (leashHolder = (mob = (Mob)t).getLeashHolder()) != null) {
            this.renderLeash(mob, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), leashHolder);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().pushPose();
        RenderUtils.translateMatrixToBone(pContext.poseStack(), pBone);
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pBone);
        RenderUtils.rotateMatrixAroundBone(pContext.poseStack(), pBone);
        RenderUtils.scaleMatrixForBone(pContext.poseStack(), pBone);
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset((Entity)this.getAnimatable(), 1.0f).toVector3f()));
            pBone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), ((Entity)this.getAnimatable()).position().toVector3f()));
        }
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pBone);
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        this.renderCubesOfBone(pBone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        this.renderChildBones(pBone, pContext);
        pContext.poseStack().popPose();
    }

    protected void applyRotations(@NotNull T pAnimatable, @NotNull PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTick, float pNativeScale) {
        if (this.isShaking(pAnimatable)) {
            pRotationYaw += (float)(Math.cos((double)((Entity)pAnimatable).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (!pAnimatable.hasPose(Pose.SLEEPING)) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pRotationYaw));
        }
        if (pAnimatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pAnimatable;
            if (livingEntity.deathTime > 0) {
                float deathRotation = ((float)livingEntity.deathTime + pPartialTick - 1.0f) / 20.0f * 1.6f;
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation(pAnimatable)));
            } else if (livingEntity.isAutoSpinAttack()) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(((float)livingEntity.tickCount + pPartialTick) * -75.0f));
            } else if (pAnimatable.hasPose(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.getBedOrientation();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation).floatValue() : pRotationYaw));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation(pAnimatable)));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
                pPoseStack.translate(0.0f, (pAnimatable.getBbHeight() + 0.1f) / pNativeScale, 0.0f);
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(@NotNull T pAnimatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(@NotNull T pAnimatable) {
        return pAnimatable.isDiscrete() ? 32.0 : 64.0;
    }

    public boolean shouldShowName(@NotNull T pAnimatable) {
        if (!(pAnimatable instanceof LivingEntity)) {
            return super.shouldShowName(pAnimatable);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(pAnimatable);
        if (this.entityRenderDispatcher.distanceToSqr(pAnimatable) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(pAnimatable instanceof Mob) || pAnimatable.shouldShowName() || pAnimatable.hasCustomName() && pAnimatable == this.entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean visibleToClient = !pAnimatable.isInvisibleTo(PlayerUtils.getClientPlayer());
        PlayerTeam entityTeam = pAnimatable.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && pAnimatable != minecraft.getCameraEntity() && visibleToClient && !pAnimatable.isVehicle();
        }
        PlayerTeam playerTeam = PlayerUtils.getClientPlayer().getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(@NotNull T pAnimatable, float pU, float pPartialTick) {
        if (!(pAnimatable instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity entity = (LivingEntity)pAnimatable;
        return OverlayTexture.pack((int)OverlayTexture.u((float)pU), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(@NotNull T animatable) {
        return animatable.isFullyFrozen();
    }

    public <E extends Entity, M extends Mob> void renderLeash(@NotNull M pMob, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, @NotNull E pLeashHolder) {
        float t;
        int i;
        float bodyAngle = Mth.lerp((float)pPartialTick, (float)pMob.yBodyRotO, (float)pMob.yBodyRot) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = pMob.getLeashOffset(pPartialTick);
        float cos = (float)Math.cos(bodyAngle);
        float sin = (float)Math.sin(bodyAngle);
        double xAngleOffset = (double)cos * leashOffset.z + (double)sin * leashOffset.x;
        double zAngleOffset = (double)sin * leashOffset.z - (double)cos * leashOffset.x;
        double lerpOriginX = Mth.lerp((double)pPartialTick, (double)pMob.xo, (double)pMob.getX()) + xAngleOffset;
        double lerpOriginY = Mth.lerp((double)pPartialTick, (double)pMob.yo, (double)pMob.getY()) + leashOffset.y;
        double lerpOriginZ = Mth.lerp((double)pPartialTick, (double)pMob.zo, (double)pMob.getZ()) + zAngleOffset;
        Vec3 ropePos = pLeashHolder.getRopeHoldPosition(pPartialTick);
        float xDif = (float)(ropePos.x - lerpOriginX);
        float yDif = (float)(ropePos.y - lerpOriginY);
        float zDif = (float)(ropePos.z - lerpOriginZ);
        float offsetMod = Mth.invSqrt((float)(xDif * xDif + zDif * zDif)) * 0.0125f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vc = pBufferSource.getBuffer(RenderType.leash());
        BlockPos mobEye = BlockPos.containing((Position)pMob.getEyePosition(pPartialTick));
        BlockPos holderEye = BlockPos.containing((Position)pLeashHolder.getEyePosition(pPartialTick));
        int mobBlockLight = this.getBlockLightLevel((Entity)pMob, mobEye);
        int holderBlockLight = pLeashHolder.isOnFire() ? 15 : pLeashHolder.level().getBrightness(LightLayer.BLOCK, holderEye);
        int mobSkyLight = pMob.level().getBrightness(LightLayer.SKY, mobEye);
        int holderSkyLight = pMob.level().getBrightness(LightLayer.SKY, holderEye);
        pPoseStack.pushPose();
        pPoseStack.translate(xAngleOffset, leashOffset.y, zAngleOffset);
        Matrix4f matrix = pPoseStack.last().pose();
        for (i = 0; i <= 24; ++i) {
            t = (float)i / 24.0f;
            BlueEntityRenderer.addLeashVertices(vc, matrix, xDif, yDif, zDif, mobBlockLight, holderBlockLight, mobSkyLight, holderSkyLight, xOffset, zOffset, t, false);
        }
        for (i = 24; i >= 0; --i) {
            t = (float)i / 24.0f;
            BlueEntityRenderer.addLeashVertices(vc, matrix, xDif, yDif, zDif, mobBlockLight, holderBlockLight, mobSkyLight, holderSkyLight, xOffset, zOffset, t, true);
        }
        pPoseStack.popPose();
    }

    private static void addLeashVertices(@NotNull VertexConsumer pBuffer, @NotNull Matrix4f pMatrix4f, float pXDif, float pYDif, float pZDif, int pMobBlockLight, int pHolderBlockLight, int pMobSkyLight, int pHolderSkyLight, float pXOffset, float pZOffset, float pSegment, boolean pIsKnot) {
        int packedLight = LightTexture.pack((int)((int)Mth.lerp((float)pSegment, (float)pMobBlockLight, (float)pHolderBlockLight)), (int)((int)Mth.lerp((float)pSegment, (float)pMobSkyLight, (float)pHolderSkyLight)));
        float colourMod = Math.round(pSegment * 24.0f) % 2 == (pIsKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * colourMod;
        float green = 0.4f * colourMod;
        float blue = 0.3f * colourMod;
        float x = pXDif * pSegment;
        float y = pYDif > 0.0f ? pYDif * pSegment * pSegment : pYDif - pYDif * (1.0f - pSegment) * (1.0f - pSegment);
        float z = pZDif * pSegment;
        float width = pIsKnot ? 0.0f : 0.025f;
        pBuffer.addVertex(pMatrix4f, x - pXOffset, y + width, z + pZOffset).setColor(red, green, blue, 1.0f).setLight(packedLight);
        pBuffer.addVertex(pMatrix4f, x + pXOffset, y + 0.025f - width, z - pZOffset).setColor(red, green, blue, 1.0f).setLight(packedLight);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((Entity)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireEntityPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireEntityPostRender(this, pContext);
    }
}

