/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityRenderUtils {
    private EntityRenderUtils() {
    }

    public static float getLerpBodyRot(@Nullable LivingEntity pEntity, float pPartialTick) {
        return pEntity == null ? 0.0f : Mth.rotLerp((float)pPartialTick, (float)pEntity.yBodyRotO, (float)pEntity.yBodyRot);
    }

    public static float getLerpHeadRot(@Nullable LivingEntity pEntity, float pPartialTick) {
        return pEntity == null ? 0.0f : Mth.rotLerp((float)pPartialTick, (float)pEntity.yHeadRotO, (float)pEntity.yHeadRot);
    }

    public static float getNetHeadYaw(float lerpHeadRot, float lerpBodyRot) {
        return lerpHeadRot - lerpBodyRot;
    }

    public static float[] adjustSittingRotations(boolean pShouldSit, @NotNull Entity pAnimatable, float pLerpHeadRot, float pLerpBodyRot, float pPartialTick) {
        Entity entity;
        float netHeadYaw = pLerpHeadRot - pLerpBodyRot;
        if (pShouldSit && (entity = pAnimatable.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            pLerpBodyRot = Mth.rotLerp((float)pPartialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            netHeadYaw = pLerpHeadRot - pLerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            pLerpBodyRot = pLerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                pLerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = pLerpHeadRot - pLerpBodyRot;
        }
        return new float[]{pLerpBodyRot, netHeadYaw};
    }

    public static void applySleepingTranslation(@NotNull PoseStack pPoseStack, @NotNull LivingEntity pLivingEntity) {
        Direction bedDirection;
        if (pLivingEntity.getPose() == Pose.SLEEPING && (bedDirection = pLivingEntity.getBedOrientation()) != null) {
            float eyePosOffset = pLivingEntity.getEyeHeight(Pose.STANDING) - 0.1f;
            pPoseStack.translate((float)(-bedDirection.getStepX()) * eyePosOffset, 0.0f, (float)(-bedDirection.getStepZ()) * eyePosOffset);
        }
    }

    public static float[] computeLimbSwing(@NotNull LivingEntity pLivingEntity, boolean pShouldSit, float pPartialTick) {
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!pShouldSit && pLivingEntity.isAlive()) {
            limbSwingAmount = pLivingEntity.walkAnimation.speed(pPartialTick);
            limbSwing = pLivingEntity.walkAnimation.position(pPartialTick);
            if (pLivingEntity.isBaby()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        return new float[]{limbSwing, limbSwingAmount};
    }

    public static boolean isEntityMoving(@NotNull LivingEntity pLivingEntity, float pMotionThreshold, float pLimbSwingAmount) {
        Vec3 velocity = pLivingEntity.getDeltaMovement();
        float avgVelocity = (float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0);
        return avgVelocity >= pMotionThreshold && pLimbSwingAmount != 0.0f;
    }
}

