/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.layer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.texture.AutoGlowingTexture;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class AutoGlowingBlueLayer<T extends BlueAnimatable>
extends BlueRenderLayer<T> {
    public AutoGlowingBlueLayer(@NotNull BlueRenderer<T> pRenderer) {
        super(pRenderer);
    }

    @Nullable
    protected RenderType getRenderType(@NotNull T pAnimatable, @Nullable MultiBufferSource pBufferSource) {
        if (!(pAnimatable instanceof Entity)) {
            return AutoGlowingTexture.getRenderType(this.getTextureResource(pAnimatable));
        }
        Entity entity = (Entity)pAnimatable;
        boolean invisible = entity.isInvisible();
        ResourceLocation texture = AutoGlowingTexture.getEmissiveResource(this.getTextureResource(pAnimatable));
        if (invisible && !entity.isInvisibleTo(PlayerUtils.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (Minecraft.getInstance().shouldEntityAppearGlowing(entity)) {
            if (invisible) {
                return RenderType.outline((ResourceLocation)texture);
            }
            return AutoGlowingTexture.getOutlineRenderType(this.getTextureResource(pAnimatable));
        }
        return invisible ? null : AutoGlowingTexture.getRenderType(this.getTextureResource(pAnimatable));
    }

    @Override
    public void render(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            this.getRenderer().reRender(full);
        } else if (pContext instanceof IRenderContext) {
            IRenderContext<T> base = pContext;
            RenderType renderType = this.getRenderType(base.animatable(), base.bufferSource());
            FullRenderContext<T> full = new FullRenderContext<T>(pContext.poseStack(), pContext.animatable(), pContext.model(), renderType, pContext.bufferSource(), null, pContext.isReRender(), pContext.partialTick(), pContext.packedLight(), pContext.packedOverlay(), pContext.color());
            this.render(full);
        }
    }
}

