/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net;

import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkManager;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.client.net.data.DataRegistrySyncPacketHandler;
import software.bluelib.net.NeoForgePacketInfo;

public class NeoForgeNetworkManager
implements NetworkManager {
    @NotNull
    public static final String PROTOCOL_VERSION = "1.0.0";

    public static void registerMessages(@NotNull RegisterPayloadHandlersEvent pEvent) {
        PayloadRegistrar registrar = pEvent.registrar("bluelib").versioned(PROTOCOL_VERSION);
        PayloadRegistrar netRegistrar = pEvent.registrar("bluelib").versioned(PROTOCOL_VERSION).executesOn(HandlerThread.NETWORK);
        HashSet syncPackets = new HashSet();
        HashSet asyncPackets = new HashSet();
        NetworkRegistry.getS2CPayloads().stream().map(NeoForgePacketInfo::new).forEach(it -> {
            boolean handleAsync = it.info().getHandler() instanceof DataRegistrySyncPacketHandler;
            if (handleAsync) {
                asyncPackets.add(it.info().getId());
            } else {
                syncPackets.add(it.info().getId());
            }
            it.registerToClient(handleAsync ? netRegistrar : registrar);
        });
        NetworkRegistry.getC2SPayloads().stream().map(NeoForgePacketInfo::new).forEach(it -> it.registerToServer(registrar));
    }

    @Override
    public void sendPacketToPlayer(@NotNull ServerPlayer pPlayer, @NotNull NetworkPacket<?> pPacket) {
        pPlayer.connection.send(pPacket);
    }

    @Override
    public void sendToServer(@NotNull NetworkPacket<?> pPacket) {
        Objects.requireNonNull(Minecraft.getInstance().getConnection()).send(pPacket);
    }

    @Override
    public void sendToAllPlayersTrackingEntity(@NotNull Entity pTrackingEntity, @NotNull NetworkPacket<?> pPacket) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)pTrackingEntity, pPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAllPlayersTrackingBlock(@NotNull ServerLevel pLevel, @NotNull BlockPos pBlockPos, @NotNull NetworkPacket<?> pPacket) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)pLevel, (ChunkPos)new ChunkPos(pBlockPos), pPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

